% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgmguru-functions-docs.R
\name{excursion}
\alias{excursion}
\title{Calculate Glucose Excursions}
\usage{
excursion(df, gap = 15)
}
\arguments{
\item{df}{A dataframe containing continuous glucose monitoring (CGM) data.
Must include columns:
\itemize{
  \item \code{id}: Subject identifier (string or factor)
  \item \code{time}: Time of measurement (POSIXct)
  \item \code{gl}: Glucose value (integer or numeric, mg/dL)
}}

\item{gap}{Gap threshold in minutes for excursion calculation (default: 15).
This parameter defines the minimum time interval between consecutive GRID events.}
}
\value{
A list containing:
\itemize{
  \item \code{excursion_vector}: Tibble with excursion results (\code{excursion})
  \item \code{episode_counts}: Tibble with episode counts per subject (\code{id}, \code{episode_counts})
  \item \code{episode_start}: Tibble with all episode starts with columns:
    \itemize{
      \item \code{id}: Subject identifier
      \item \code{time}: Timestamp at which the event occurs; equivalent to \code{df$time[indices]}
      \item \code{gl}: Glucose value at the event; equivalent to \code{df$gl[indices]}
      \item \code{indices}: R-based (1-indexed) row number(s) in \code{df} denoting where the event occurs
    }
}
}
\description{
Calculates glucose excursions in CGM data. An excursion is defined as
a \eqn{>} 70 mg/dL (\eqn{>} 3.9 mmol/L) rise within 2 hours, not preceded by a value
\eqn{<} 70 mg/dL (\eqn{<} 3.9 mmol/L).
}
\section{Notes}{

- \code{gap} is minutes; change to enforce minimum separation between excursions.
}

\examples{
# Load sample data
library(iglu)
data(example_data_5_subject)
data(example_data_hall)

# Calculate glucose excursions
excursion_result <- excursion(example_data_5_subject, gap = 15)
print(paste("Excursion vector length:", length(excursion_result$excursion_vector)))
print(excursion_result$episode_counts)

# Excursion analysis with different gap
excursion_30min <- excursion(example_data_5_subject, gap = 30)

# Analysis on larger dataset
large_excursion <- excursion(example_data_hall, gap = 15)
print(paste("Excursion vector length in larger dataset:", length(large_excursion$excursion_vector)))
print(paste("Total episodes:", sum(large_excursion$episode_counts$episode_counts)))
}
\references{
Edwards, S., et al. (2022). Use of connected pen as a diagnostic tool to evaluate missed bolus dosing behavior in people with type 1 and type 2 diabetes. Diabetes Technology & Therapeutics, 24(1), 61-66.
}
\seealso{
\link{grid}
}
