% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{metadata}
\alias{metadata}
\title{CDL metadata.}
\usage{
metadata(state, year, https = TRUE, ssl.verifypeer = TRUE)
}
\arguments{
\item{state}{A numeric fips code, a state's two letter abbreviation, or a state name.}

\item{year}{A numeric year.}

\item{https}{Legacy https, all traffic uses https, if you need http provide alternative url.}

\item{ssl.verifypeer}{An optional boolean to turn on and off ssl verfication, default is on.}
}
\value{
The metadata for the state identified by the state argument.  If no match can be made, the 
 program returns NA.  The metadata is returned as a list with two elements, overall and class 
 specific metrics, each in dataframes.
}
\description{
\code{metadata} downloads classification and crop class metadata from the cropscape website.
}
\details{
Cropscape provides classification and crop class metadata on the Cropland Data Layer.
This function fetches this data through scraping cropscape html.
}
\examples{
\dontrun{
metadata("ia", 2007)
metadata('North Carolina',2008)
metadata(44,2017)
}
}
\author{
Jonathan Lisic, \email{jlisic@gmail.com}
}
