% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fips.R
\name{fips}
\alias{fips}
\title{FIPS code conversion function.}
\usage{
fips(x, to = "FIPS")
}
\arguments{
\item{x}{A vector, data frame or matrix of character strings or numeric FIPS codes. Character input can be the two-letter 
postal abbreviation, the full name of a state, or a FIPS code in character format. 
The string is case insensitive.  FIPS codes are the only numeric input supported.}

\item{to}{A character string of output type:  "FIPS" will return a numeric fips code.
"Abbreviation" will return a two letter state abbreviation.  "Name" will return the
full state name with spaces.  The default output is a numeric FIPS code.}
}
\value{
The output type specified by the "to" argument.  If no match can be made, the 
 program returns NA.
}
\description{
\code{fips} converts U.S. state and county names and abbreviations to and from FIPS codes.
}
\details{
The Federal Information Processing Standard (FIPS) provides a set of standard numeric 
codes for referring to U.S. states.  This function converts between FIPS codes, state two 
letter abbreviations, and full state names.

County abbreviations are supported for FIPS to name conversion only.
}
\examples{
fips("ia")
fips('northcarolina', to='Abbreviation')
fips('North Carolina')
fips(44,to='Name')
fips("01001",to='Name')
}
\author{
Jonathan Lisic, \email{jlisic@gmail.com}
}
