% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respiratory-condition.R
\name{resp_condition_fun2}
\alias{resp_condition_fun2}
\title{resp_condition_fun2}
\usage{
resp_condition_fun2(DHHGAGE_cont, CCC_91E, CCC_91F, CCC_91A, CCC_031)
}
\arguments{
\item{DHHGAGE_cont}{continuous age variable.}

\item{CCC_91E}{variable indicating if respondent has emphysema}

\item{CCC_91F}{variable indicating if respondent has COPD}

\item{CCC_91A}{variable indicating if respondent has chronic bronchitis}

\item{CCC_031}{variable indicating if respondent has asthma}
}
\value{
a categorical variable (resp_condition_der) with 3 levels:

 \enumerate{
 \item respondent is over the age of 35 and has a respiratory condition
 \item respondent is under the age of 35 and has a respiratory condition
 \item respondent does not have a respiratory condition
 }
}
\description{
This is one of 3 functions used to create a derived variable
 (resp_condition_der) that determines if a respondents has a respiratory
 condition. This function is for CCHS cycles (2005-2007) that use COPD &
 Emphysema as separate variables, as well as Bronchitis. Asthma is used
 across CCHS cycles as a separate variable.
}
\examples{

# Using resp_condition_fun2() to create values across CCHS cycles
# (2005-2007) resp_condition_fun2() is specified in
# variable_details.csv along with the CCHS variables and cycles included.

# To transform resp_condition_der, use rec_with_table() for each CCHS cycle
# and specify resp_condition_der, along with the various respiratory
# variables. Then by using merge_rec_data() you can combine
# resp_condition_der across cycles.

library(cchsflow)

resp2005 <- suppressWarnings(rec_with_table(
  cchs2005_p, c(
    "DHHGAGE_cont", "CCC_91E", "CCC_91F", "CCC_91A", "CCC_031",
    "resp_condition_der"
  )
))

head(resp2005)

resp2007_2008 <- suppressWarnings(rec_with_table(
  cchs2007_2008_p,  c(
    "DHHGAGE_cont", "CCC_91E", "CCC_91F", "CCC_91A", "CCC_031",
    "resp_condition_der"
  )
))

tail(resp2007_2008)

combined_resp <- suppressWarnings(merge_rec_data(resp2005, resp2007_2008))

head(combined_resp)
tail(combined_resp)
}
\seealso{
\code{\link{resp_condition_fun1}}, \code{\link{resp_condition_fun3}}
}
