% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.R
\name{knit_print.caugi_export}
\alias{knit_print.caugi_export}
\title{Knit Print Method for caugi_export}
\arguments{
\item{x}{A \code{caugi_export} object.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A \code{knit_asis} object for rendering by knitr.
}
\description{
Renders caugi export objects as code blocks in Quarto/R Markdown documents.
This method is automatically invoked when an export object is the last
expression in a code chunk.
}
\details{
This method enables seamless rendering of caugi graphs in Quarto and
R Markdown. The code block type is determined by the export format.
Simply use an export function (e.g., \code{to_dot(cg)}) as the last expression
in a chunk with \code{output: asis}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#| output: asis
to_dot(cg)
}\if{html}{\out{</div>}}
}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{caugi_serialize}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
