% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{npi_cat}
\alias{npi_cat}
\title{Narcissistic Personality Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \code{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.

See \url{https://openpsychometrics.org/_rawdata/}, maintained by Eric Jorgenson, for the raw Open Source Psychometrics Project data.
}
\usage{
data(npi_cat)
}
\description{
Cat object containing item parameters for latent trait model fit with responses
to the  40 item Narcissistic Personality inventory
}
\details{
Cat object containing item parameters for latent trait model fit with
2945 response profiles collected by Qualtrics in June 2018
and 10440 response profiles collected by the Open Source Psychometrics Project in 2012.

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{ltmCat}} for details regarding the latent trait model.

A normal prior was chosen with mean from the theta estimates from the Qualtrics sample (-.069) and a standard deviation (1)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Item responses are paired. Respondents had to choose the one that fit them the best.

The wording of the item responses is: 

\describe{
\item{\code{Q1*}}{0 = I am not good at influencing people. 1 = I have a natural talent for influencing people.}
\item{\code{Q2}}{0 = Modesty doesn't become me. 1 = I am essentially a modest person.}
\item{\code{Q3}}{0 = I would do almost anything on a dare. 1 = I tend to be a fairly cautious person.}
\item{\code{Q4}}{0 = When people compliment me I sometimes get embarrassed. 1 = I know that I am good because everybody keeps telling me so.}
\item{\code{Q5}}{0 = The thought of ruling the world frightens the hell out of me. 1 = If I ruled the world it would be a better place.}
\item{\code{Q6}}{0 = I can usually talk my way out of anything. 1 = I try to accept the consequences of my behavior.}
\item{\code{Q7}}{0 = I prefer to blend in with the crowd. 1 = I like to be the center of attention.}
\item{\code{Q8}}{0 = I will be a success. 1 = I am not too concerned about success.}
\item{\code{Q9}}{0 = I am no better or worse than most people. 1 = I think I am a special person.}
\item{\code{Q10}}{0 = I am not sure if I would make a good leader. 1 = I see myself as a good leader.}
\item{\code{Q11}}{0 = I am assertive. 1 = I wish I were more assertive.}
\item{\code{Q12}}{0 = I like to have authority over other people. 1 = I don't mind following orders.}
\item{\code{Q13}}{0 = I find it easy to manipulate people. 1 = I don't like it when I find myself manipulating people.}
\item{\code{Q14}}{0 = I insist upon getting the respect that is due me. 1 = I usually get the respect that I deserve.}
\item{\code{Q15}}{0 = I don't particularly like to show off my body. 1 = I like to show off my body.}
\item{\code{Q16}}{0 = I can read people like a book. 1 = People are sometimes hard to understand.}
\item{\code{Q17}}{0 = If I feel competent I am willing to take responsibility for making decisions. 1 = I like to take responsibility for making decisions.}
\item{\code{Q18}}{0 = I just want to be reasonably happy. 1 = I want to amount to something in the eyes of the world.}
\item{\code{Q19}}{0 = My body is nothing special. 1 = I like to look at my body.}
\item{\code{Q20}}{0 = I try not to be a show off. 1 = I will usually show off if I get the chance.}
\item{\code{Q21}}{0 = I always know what I am doing. 1 = Sometimes I am not sure of what I am doing.}
\item{\code{Q22}}{0 = I sometimes depend on people to get things done. 1 = I rarely depend on anyone else to get things done.}
\item{\code{Q23}}{0 = Sometimes I tell good stories. 1 = Everybody likes to hear my stories.}
\item{\code{Q24}}{0 = I expect a great deal from other people. 1 = I like to do things for other people.}
\item{\code{Q25}}{0 = I will never be satisfied until I get all that I deserve. 1 = I take my satisfactions as they come.}
\item{\code{Q26}}{0 = Compliments embarrass me. 1 = I like to be complimented.}
\item{\code{Q27}}{0 = I have a strong will to power. 1 = Power for its own sake doesn't interest me.}
\item{\code{Q28}}{0 = I don't care about new fads and fashions. 1 = I like to start new fads and fashions.}
\item{\code{Q29}}{0 = I like to look at myself in the mirror. 1 = I am not particularly interested in looking at myself in the mirror.}
\item{\code{Q30}}{0 = I really like to be the center of attention. 1 = It makes me uncomfortable to be the center of attention.}
\item{\code{Q31}}{0 = I can live my life in any way I want to. 1 = People can't always live their lives in terms of what they want.}
\item{\code{Q32}}{0 = Being an authority doesn't mean that much to me. 1 = People always seem to recognize my authority.}
\item{\code{Q33}}{0 = I would prefer to be a leader. 1 = It makes little difference to me whether I am a leader or not.}
\item{\code{Q34}}{0 = I am going to be a great person. 1 = I hope I am going to be successful.}
\item{\code{Q35}}{0 = People sometimes believe what I tell them. 1 = I can make anybody believe anything I want them to.}
\item{\code{Q36}}{0 = I am a born leader. 1 = Leadership is a quality that takes a long time to develop.}
\item{\code{Q37}}{0 = I wish somebody would someday write my biography. 1 = I don't like people to pry into my life for any reason.}
\item{\code{Q38}}{0 = I get upset when people don't notice how I look when I go out in public. 1 = I don't mind blending into the crowd when I go out in public.}
\item{\code{Q39}}{0 = I am more capable than other people. 1 = There is a lot that I can learn from other people.}
\item{\code{Q40}}{0 = I am much like everybody else. 1 = I am an extraordinary person.}
}

*Note that Item 1 is "reverse coded" from the coding that is typically used.
This is because item parameter estimation constrains the first item's discrimination parameter
to be positive.  So the reverse coding was done for the more intuitive
interpretation of item parameters and theta
estimates as larger, positive values indicate "more" of the latent trait.
}
\references{
Raskin, R., and H. Terry (1988), "A Principal-Components Analysis of the Narcissistic Personality
Inventory and Further Evidence of Its Construct Validity," Journal of Personality and Social
Psychology, 54, 890-902.

Open Source Psychometrics Project. \url{https://openpsychometrics.org/_rawdata/}
}
\seealso{
\code{\link{Cat-class}}, \code{\link{ltmCat}}
}
\keyword{datasets}
