% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_output.R
\name{total_output}
\alias{total_output}
\title{Calculate Total Output and Generate Plot}
\usage{
total_output(
  data = x$data,
  time = time,
  date_format = c("\%d/\%m/\%Y"),
  name = theatre,
  val = carbon_price_credit,
  plot_by = c("default", "month", "year")
)
}
\arguments{
\item{data}{The data frame containing the data.}

\item{time}{The variable representing the time dimension.}

\item{date_format}{The date format for the time variable (optional, default: c("\%d/\%m/\%Y")).}

\item{name}{The variable representing the grouping variable.}

\item{val}{The variable to calculate the total output for (default: carbon_price_credit).}

\item{plot_by}{The grouping type for the total output plot ("default", "month", "year").}
}
\value{
A ggplot object showing the total output plot.
}
\description{
This function calculates the total output and generates a plot based on the specified parameters.
}
\details{
This function calculates the total output by grouping the data based on the specified parameters
(grouping variable and time dimension). It then summarises the specified variable (CPI or emissions) using the sum function.
The resulting data is used to create a line plot showing the total output over time, with each group represented
by a different color. The plot can be grouped by the default grouping, month, or year, based on the plot_by parameter.
}
