% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_foreman.R
\name{calculateIndicatorCor}
\alias{calculateIndicatorCor}
\title{Internal: Calculate indicator correlation matrix}
\usage{
calculateIndicatorCor(
  .X_cleaned           = NULL, 
  .approach_cor_robust = "none"
 )
}
\arguments{
\item{.X_cleaned}{A data.frame of processed data (cleaned and ordered). Note: \code{X_cleaned}
may not be scaled!}

\item{.approach_cor_robust}{Character string. Approach used to obtain a robust
indicator correlation matrix. One of: "\emph{none}" in which case the standard
Bravais-Pearson correlation is used,
"\emph{spearman}" for the Spearman rank correlation, or
"\emph{mcd}" via \code{\link[MASS:cov.rob]{MASS::cov.rob()}} for a robust correlation matrix.
Defaults to "\emph{none}". Note that many postestimation procedures (such as
\code{\link[=testOMF]{testOMF()}} or \code{\link[=fit]{fit()}} implicitly assume a continuous
indicator correlation matrix (e.g. Bravais-Pearson correlation matrix).
Only use if you know what you are doing.}
}
\value{
A list with elements:
\describe{
\item{\verb{$S}}{The (K x K) indicator correlation matrix}
\item{\verb{$cor_type}}{The type(s) of indicator correlation computed (
"Pearson", "Polyserial", "Polychoric")}
\item{\verb{$thre_est}}{Currently ignored (NULL)}
}
}
\description{
Calculate the indicator correlation matrix using conventional or robust methods.
}
\details{
If \code{.approach_cor_robust = "none"} (the default) the type of correlation computed
depends on the types of the columns of \code{.X_cleaned} (i.e., the indicators)
involved in the computation.
\describe{
\item{\code{Numeric-numeric}}{If both columns (indicators) involved are numeric, the
Bravais-Pearson product-moment correlation is computed (via \code{\link[stats:cor]{stats::cor()}}).}
\item{\code{Numeric-factor}}{If any of the columns is a factor variable, the
polyserial correlation \insertCite{Drasgow1988}{cSEM} is computed (via
\code{\link[polycor:polyserial]{polycor::polyserial()}}).}
\item{\code{Factor-factor}}{If both columns are factor variables, the
polychoric correlation \insertCite{Drasgow1988}{cSEM} is computed (via
\code{\link[polycor:polychor]{polycor::polychor()}}).}
}
Note: logical input is treated as a 0-1 factor variable.

If  \code{"mcd"} (= minimum covariance determinant), the MCD estimator
\insertCite{Rousseeuw1999}{cSEM}, a robust covariance estimator, is applied
(via \code{\link[MASS:cov.rob]{MASS::cov.rob()}}).

If \code{"spearman"}, the Spearman rank correlation is used (via \code{\link[stats:cor]{stats::cor()}}).
}
\references{
\insertAllCited{}
}
\keyword{internal}
