% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_delete.R
\name{ZoteroDelete}
\alias{ZoteroDelete}
\title{Delete collections and items from a Zotero library}
\usage{
ZoteroDelete(
  zotero,
  delete.collections = FALSE,
  delete.items = FALSE,
  delete.limit = 50,
  force = FALSE,
  ragnarok = FALSE,
  silent = FALSE
)
}
\arguments{
\item{zotero}{A list with information on the specified Zotero library (e.g.,
id, API key, collections, and items)}

\item{delete.collections}{Try to delete specified collections, Default: TRUE}

\item{delete.items}{Try to delete specified items?, Default: TRUE}

\item{delete.limit}{Number of collections/items to delete per request (max
50), Default: 50}

\item{force}{Force is seldom wise, but sometimes..., Default: FALSE}

\item{ragnarok}{Delete EVERYTHING in the specified library, Default: FALSE}

\item{silent}{c2z is noisy, tell it to be quiet, Default: FALSE}
}
\value{
A list with information on the specified Zotero library (e.g.,
  deleted collections and items)
}
\description{
Cleaning the Zotero library
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Delete everything in a group
  example <- ZoteroDelete(
    Zotero(
      user = FALSE,
      id = "4988497",
      api = "RqlAmlH5l1KPghfCseAq1sQ1"
    ),
    ragnarok = TRUE,
    force = TRUE
  )
}
}
\seealso{
\code{\link[httr]{add_headers}}, \code{\link[httr]{RETRY}}
}
