% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fread_trips_data.R
\name{fread_trips_data}
\alias{fread_trips_data}
\title{Fast read historical bike trips data in Norway to R}
\usage{
fread_trips_data(year, month, city)
}
\arguments{
\item{year}{A number. The year that you want to download data for.}

\item{month}{A number. The month that you want to download data for.}

\item{city}{A string. The city you want to download data from. The options are
"Oslo", "Bergen", and "Trondheim".}
}
\value{
The function reads in bike trips data for the specified year, month, and city
to R as a tibble.
}
\description{
\code{fread_trips_data()} imports anonymized historical bike trips data for
the city of Oslo, Bergen, and Trondheim, in Norway, directly to R.

\code{fread_trips_data()} utilizes the
\code{\link[data.table:fread]{fread()}} function from the \code{data.table}
package to fast read the CSV-files. Hence, it is much faster than
\code{read_trips_data}. \code{fread_trips_data()} requires that you
have the \code{data.table} package installed.

The data is provided according to the Norwegian License for Open Government
Data 2.0 (\href{https://data.norge.no/nlod/en/2.0}{NLOD 2.0}).

The data is read from:

\itemize{
  \item \href{https://oslobysykkel.no/en/open-data/historical}{Oslo City Bike}
  \item \href{https://bergenbysykkel.no/en/open-data/historical}{Bergen City Bike}
  \item \href{https://trondheimbysykkel.no/en/open-data/historical}{Trondheim City Bike}
}
}
\examples{
\dontrun{

# Fast read bike trips data for the month of January 2019 in Bergen
bergen_trips <- fread_trips_data(year = 2019, month = 1, city = "Bergen")

# Fast read bike trips data for the month of October 2018 in Trondheim
trondheim_trips <- fread_trips_data(2018, 10, "Trondheim")

}

}
