% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_collar.R
\name{collarStrategy}
\alias{collarStrategy}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven point (BE) at expiration for Collar Strategy and draws its graph in the Plots tab.}
\usage{
collarStrategy(
  ST,
  S0,
  XL,
  XH,
  PXL,
  CXH,
  hl = 0,
  hu = 1.5,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Profit / Loss [ PnL ] at Expiration ($)",
  main = "Collar Strategy",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{S0}{Initial Stock Price.}

\item{XL}{Lower Strike Price or eXercise price.}

\item{XH}{Higher Strike Price or eXercise price.}

\item{PXL}{Call Premium paid for the bought Calls at Lower Strike.}

\item{CXH}{Call Premium received for the sold Calls at higher Strike.}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Collar Strategy.
}
\description{
This strategy is a covered call augmented by a long put option as insurance against the stock price falling. It amounts to buying stock, buying an OTM put option with a strike price XL, and selling an OTM call option with a higher strike price XH. The outlook of trader or investor is moderately bullish (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration and also the Breakeven (BE) point for Collar Strategy and draws its graph in the Plots tab.
}
\examples{
collarStrategy(30,19,20,35,6.50,5)
collarStrategy(800,770,750,790,80,70,hl=0.92,hu=1.02)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
