% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{bslearn}
\alias{bslearn}
\title{Find the Optimal Boolean Rule for Binary Classification}
\usage{
bslearn(bx, y, control = bscontrol())
}
\arguments{
\item{bx}{a data frame with binary (0 and 1) entries.}

\item{y}{an integer vector with binary entries.}

\item{control}{an object of class \code{bscontrol()}, specifying the algorithmic parameters. The list should contain the following attributes: \emph{opt.model}, a character string in {\code{'gini','error'}} indicating the optimization model to solve, \emph{opt.solver}, a character string in {\code{'enum_c', 'enum'}} indicating the algorithm to be used.}
}
\value{
a list containing the splitting solution.
}
\description{
The function solves a mixed integer program (MIP) to maximize the Gini reduction (opt.model = 'gini') or minimize the number of misclassified cases (opt.model = 'error').
}
\examples{
x <- auto[, c('mpg', 'cylinders', 'displacement')]
y <- ifelse(auto$origin == 'USA', 1L, 0L)
# binarize x by y = 1
bx <- binarize(x, y, target = 1)
# learn the optimal Boolean rule
bssol <- bslearn(bx, y, bscontrol(opt.solver = 'enum'))
cat(paste("Optimal rule:" , bssol$rules, "\n"))
}
