% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process}
\alias{process}
\title{process: rotates and calulates reliability for Stan output}
\usage{
process(Loading_Matrix, Format, Rotate)
}
\arguments{
\item{Loading_Matrix}{S by P*Q matrix of loading samples.}

\item{Format}{list formatted data file provided for Stan}

\item{Rotate}{If Q>1, rotation (for options, see GPArotation package)}
}
\value{
Returns rotated loadings, uniqueness, communality, and reliability.
}
\description{
This function processes Stan loading matrix data.
}
\examples{
\dontrun{
your_data_s=standardize(your_data)
formatted_data=prep(your_data_s,nfactors=3)
out=sampling(model, data=formatted_data, iter=5000, seed=999)
res=as.matrix(out)
unpacked=unpack(Samples=res,Format=formatted_data)

processed=process(Loading_Matrix=unpacked$Loading_Matrix,
                 Format=formatted_data,
                 Rotate="oblimin")}


}
