% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{prep}
\alias{prep}
\title{prep: Prepare Data File for Bayesian Analysis}
\usage{
prep(data, nfactors, Prior)
}
\arguments{
\item{data}{N by P data matrix.}

\item{nfactors}{Number of factors to extract.}

\item{Prior}{Prior loading matrix.}
}
\value{
Returns a formatted data file for use with Stan MCMC sampler.
}
\description{
This function prepares data for analysis using Stan factor analysis code.
}
\examples{
set.seed(999)
your_data=data.frame(mvrnorm(n=20,mu=c(0,0,0,0,0),
                            Sigma=matrix(c(4,2,2,2,2,
                                           2,4,2,2,2,
                                           2,2,4,2,2,
                                           2,2,2,4,2,
                                           2,2,2,2,4),
                                         nrow=5, ncol=5)))
colnames(your_data)=c("x1","x2","x3","x4","x5")
your_data_miss=matrix(ncol=5,nrow=20)
for (i in 1:20){
for (p in 1:5){
   your_data_miss[i,p]=ifelse(runif(1,0,1)<0.2,NA,your_data[i,p])
 }
}
formatted_data=prep(your_data_miss,nfactors=3)


}
