% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbfs.R
\name{db_dbfs_add_block}
\alias{db_dbfs_add_block}
\title{DBFS Add Block}
\usage{
db_dbfs_add_block(
  handle,
  data,
  convert_to_raw = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{handle}{Handle on an open stream.}

\item{data}{Either a path for file on local system or a character/raw
vector that will be base64-encoded. This has a limit of 1 MB.}

\item{convert_to_raw}{Boolean (Default: \code{FALSE}), if \code{TRUE} will convert
character vector to raw via \code{\link[=as.raw]{as.raw()}}.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Append a block of data to the stream specified by the input handle.
}
\details{
\itemize{
\item If the handle does not exist, this call will throw an exception with
\code{RESOURCE_DOES_NOT_EXIST.}
\item If the block of data exceeds 1 MB, this call will throw an exception with
\code{MAX_BLOCK_SIZE_EXCEEDED.}
}
}
\section{Typical File Upload Flow}{

\itemize{
\item Call create and get a handle via \code{\link[=db_dbfs_create]{db_dbfs_create()}}
\item Make one or more \code{\link[=db_dbfs_add_block]{db_dbfs_add_block()}} calls with the handle you have
\item Call \code{\link[=db_dbfs_close]{db_dbfs_close()}} with the handle you have
}
}

\seealso{
Other DBFS API: 
\code{\link{db_dbfs_close}()},
\code{\link{db_dbfs_create}()},
\code{\link{db_dbfs_delete}()},
\code{\link{db_dbfs_get_status}()},
\code{\link{db_dbfs_list}()},
\code{\link{db_dbfs_mkdirs}()},
\code{\link{db_dbfs_move}()},
\code{\link{db_dbfs_put}()},
\code{\link{db_dbfs_read}()}
}
\concept{DBFS API}
