% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DirectBootstrapMethods.R
\name{direct.boot.stsrs}
\alias{direct.boot.stsrs}
\title{Direct Bootstrap Methods for Survey Data}
\usage{
direct.boot.stsrs(
  data,
  population.size,
  R,
  parameter = "total",
  bootstrap.method = "Rao.Wu",
  boot.sample.size = NULL
)
}
\arguments{
\item{data}{A vector, matrix or data frame. If it is a matrix or data frame then the column of study variable has to be named \code{study.variable}.  If the sampling design is STSRSWOR, a column identifying strata named \code{stratum} has to be included.}

\item{population.size}{A vector of stratum population sizes}

\item{R}{The number of bootstrap replicates}

\item{parameter}{One of the following population parameters can be applied: \code{"total"} (population total), \code{"mean"} (population mean), \code{"quartile.25"} (population 1st quartile), \code{"quartile.50"} or \code{"median"} (population median) or \code{"quartile.75"} (population 3rd quartile). If the parameter of interest is the population mean or total, the HT-estimator is applied. If the parameter of interest is a population quartile, the estimator in Sarndal, Swensson, and Wretman (1992, Chapter 5) is applied. The default is the population total.}

\item{bootstrap.method}{One of the following bootstrap methods can be applied: \code{"Efron"} (Efron, 1979), \code{"McCarthy.Snowden"} (McCarthy and Snowden, 1985), \code{"Rao.Wu"} (Rao and Wu, 1988) or \code{"Sitter.BMM"} (Sitter, 1992). The default is \code{"Rao.Wu"}.}

\item{boot.sample.size}{If the method of Rao and Wu (1988) is applied, a vector of bootstrap sample sizes for each stratum may be specified. The length of this vector must match the number of strata. By default, if 'boot.sample.size' is not specified, the bootstrap sample size within each stratum will be 'nh-3', where 'nh' is the original sample size in stratum 'h'.}
}
\value{
\code{boot.statistic} A vector of bootstrap statistics

\code{boot.var} The bootstrap variance estimator of the estimator of the parameter of interest

\code{boot.mean} The average of the bootstrap estimator of the parameter of interest

\code{boot.sample} For each iteration, a list of results is generated, including three columns: bootstrap values (which may be rescaled values if resampling is done on a rescaled version of the original sample), selected indices in each stratum, and a stratum identifier column.
}
\description{
The function \code{direct.boot.stsrs} applies one of the following bootstrap methods on complete (full response) survey data selected under either SRSWOR or STSRSWOR: Efron (1979), McCarthy and Snowden (1985), Rao and Wu (1988) and Sitter (1992, JASA).
}
\examples{

R<- 20

data(data_samp_srs)
population_size<- 6000
# The sampling fraction is about 30\%.
# data_samp_srs is a sample taken from data_pop available in the package.

boot.RW<- direct.boot.stsrs(data_samp_srs, population_size, R)
boot.RW$boot.var

boot.Efron<- direct.boot.stsrs(data_samp_srs, population_size, R,
              parameter="total", bootstrap.method="Efron")
boot.Efron$boot.var

boot.RW.med<- direct.boot.stsrs(data_samp_srs, population_size, R,
               parameter="median")
boot.RW.med$boot.var

data(data_samp_stsrs)
population_size_st<- c(4500, 6300, 3500, 2000, 1500)
# The overall sampling fraction is about 30\%.
# data_samp_stsrs is a sample taken from data_pop_st available in the package.

boot.RW.st<- direct.boot.stsrs(data_samp_stsrs, population_size_st, R,
              parameter="total", bootstrap.method="Rao.Wu")
boot.RW.st$boot.statistic



}
\references{
Efron, B. (1979). Bootstrap methods: another look at the jackknife. The Annals of Statistics 7 (1), 1–26.

McCarthy, P. J. and C. B. Snowden (1985). The bootstrap and finite population sampling. Vital and Health Statistics, Series 2, No. 95. DHHS Publication No. (PHS) 85–1369. Public Health Service. Washington. U.S. Government Printing Office.

Rao, J. N. K. and C. F. J. Wu (1988). Resampling inference with complex survey data. Journal of the American Statistical Association 83 (401), 231–241.

Särndal, C.-E., Swensson, B. & Wretman, J. (1992). Model-Assisted Survey Sampling. NewYork: Springer.

Sitter, R. R. (1992). A resampling procedure for complex survey data. Journal of the American Statistical Association 87 (419), 755–765.
}
