% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetBlocks.R
\name{GetBlocks}
\alias{GetBlocks}
\title{Compute Block Splitting for Atomic Markov Chains}
\usage{
GetBlocks(X, atom, m = min(X), M = max(X), func = sum, ...)
}
\arguments{
\item{X}{A numeric vector representing a Markov chain.}

\item{atom}{A numeric value; an atom of the Markov chain.}

\item{m}{A numeric value; the lower truncation threshold
Default is the 5th percentile of \code{X}.}

\item{M}{A numeric value; the upper truncation threshold
Default is the 95th percentile of \code{X}.}

\item{func}{A function to apply to each block. Default is \code{sum}.}

\item{...}{Additional arguments passed to the function \code{func}.}
}
\value{
Returns a list containing:
\enumerate{
\item A data frame with the following columns:
\itemize{
\item \code{Time} - the index of each observation,
\item \code{X} - values of the process,
\item \code{Bnumber} - block number assigned to each observation,
\item \code{regen} - indicator (1 or 0) of regeneration times. 1 corresponds to
the regeneration time.
}
\item A matrix summarizing block characteristics with the following columns:
\itemize{
\item \code{Block number} - the block index,
\item \code{Block length} - number of observations in the block,
\item \code{Truncated sum} - the value of \code{func} applied to truncated
observations in the block,
\item \code{Valid points} - number of observations within the truncation thresholds,
\item \code{Winsorized value} - the Winsorized value of \code{func} applied to the block,
\item \code{Start index} - the starting index of the block,
\item \code{End index} -  the ending index of the block.
}
\item \code{Total blocks} - the total number of regeneration blocks.
}
}
\description{
Computes regenerative blocks for atomic
Markov chains.
}
\details{
Identifies values in \code{X} equal to \code{atom} to
determines regeneration times and creates regeneration blocks (or cycles).
The function then assigns block numbers, counts observations in each block, and calculates
various statistics for each block.
}
\examples{
X = genMM1(1000, 1, 2)
blocks = GetBlocks(X, 0, func=sum) # compute sum over all blocks (without truncation)
# compute sum over all blocks (with truncation over quantiles of order 5\% and 95\%)
blocks = GetBlocks(X, 0, func=sum,m=quantile(X,0.05),M=quantile(X,0.95)) 

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.
}
\seealso{
\code{\link{findBestEpsilon}}, \code{\link{ftrunc}},
\code{\link{regenboot}}, \code{\link{smallEnsemble}}.
}
\keyword{"Markov}
\keyword{"Regenerative}
\keyword{Atom}
\keyword{Block}
\keyword{Bootstrap"}
\keyword{chains"}
