% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_df.R
\name{convert_df}
\alias{convert_df}
\title{Convert a Query Result into a Data Frame}
\usage{
convert_df(
  query_result,
  field_names = c("node_id", "n.identifier", "n.name", "n.source")
)
}
\arguments{
\item{query_result}{A list (or similar structure) representing the query result,
typically containing entries from which fields can be extracted.}

\item{field_names}{A character vector of field names to be extracted from each
entry in \code{query_result}. Defaults to \code{c("node_id", "n_identifier", "n.name", "n.source")}.}
}
\value{
A data frame with one row per entry in \code{query_result}, and columns
corresponding to the specified \code{field_names}. Missing fields are filled with \code{NA}.
}
\description{
This function takes a query result object and transforms it into a data frame
with specified field names. For each entry in the query result, it attempts
to extract values corresponding to the given field names. If a particular field
does not exist in the entry, it is replaced with \code{NA}.
}
\examples{
\donttest{
# Suppose query_result is a list of named lists:
query_result = list(
  list(node_id = 1, n = list(identifier = 1, name = "some node", source = "internet")),
  list(node_id = 2, n = list(identifier = 2, name = "some other node", source = "library"))
)

query_result_df = convert_df(
  query_result,
  field_names = c("node_id", "n.identifier", "n.name", "n.source")
)
}

}
