% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMSC-loo.R
\name{BMSC_loo}
\alias{BMSC_loo}
\alias{BMSC_waic}
\alias{plot.loo_BMSC}
\alias{print.waic_BMSC}
\alias{print.loo_BMSC}
\title{loo and waic.}
\usage{
BMSC_loo(x, cores = 1, ...)

BMSC_waic(x, ...)

\method{plot}{loo_BMSC}(x, ...)

\method{print}{waic_BMSC}(x, ...)

\method{print}{loo_BMSC}(x, ...)
}
\arguments{
\item{x}{An object of class \code{BMSC}, resulting from the
\link{BMSC} function.}

\item{cores}{The number of cores for the
`loo::relative_eff` function}

\item{...}{for `BMSC_loo` and `BMSC_waic`
further arguments passed to the `loo::extract_log_lik` function.
for `print` and `plot` methods further arguments to be passed to the
`print` or `plot` functions}
}
\value{
for `BMSC_loo` a list with the log likelihood of the single case and the
        control group,
        the MCMC effective sample size divided by the total sample size,
        and the leave-one-out cross-validation.
        For `BMSC_waic` a list with the log likelihood of the single
        case and the control group, and the waic scores.
}
\description{
bmscstan wrapper for computing approximate leave-one-out cross-validation
(loo) and Watanabe-Akaike Information Criterion or
Widely Applicable Information Criterion (WAIC)
using PSIS-LOO
for the single case and the control group
}
