% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{attractiveness}
\alias{attractiveness}
\title{Extract the attractivenesses from a spatial interaction model object}
\usage{
attractiveness(sim, ...)
}
\arguments{
\item{sim}{a spatial interaction model object}

\item{...}{additional parameters}
}
\value{
a vector of attractivenesses at the destination locations
}
\description{
Extract the attractivenesses from a spatial interaction model object
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- log(french_cities$population[1:10])
attractiveness <- log(french_cities$area[1:10])
model <- static_blvim(distances, production, 1.5, 1 / 250, attractiveness)
attractiveness(model)
## the names of the attractiveness vector are set from the distance matrix
## we remove them for testing equality
all.equal(as.numeric(attractiveness(model)), attractiveness)
}
\seealso{
\code{\link[=production]{production()}}, \code{\link[=destination_flow]{destination_flow()}}
}
