% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setDefaultPriors.R
\name{setDefaultPriors}
\alias{setDefaultPriors}
\title{Sets the prior distribution parameters for all parameters not named in priorsList}
\usage{
setDefaultPriors(
  normalMean = 0,
  normalVariance = 1,
  normalCovariance = 0,
  dirichletAlpha = 1
)
}
\arguments{
\item{normalMean}{Sets the prior distribution mean for all parameters with
normal distributions not named in priorsList. Defaults to \code{0}.}

\item{normalVariance}{Sets the prior distribution variance for all parameters with
normal distributions not named in priorsList. Defaults to \code{1000}.}

\item{normalCovariance}{Sets the prior distribution covariance for all parameters with
multivariate normal distributions not named in priorsList. Defaults to \code{0}.}

\item{dirichletAlpha}{Sets the prior distribution parameter values when variable distributions are Dirichlet. Defaults to \code{1}.}
}
\value{
A list containing named values for each argument in the function.
}
\description{
All parameters not named in priorsList, an input argument to
             \code{\link{blatentEstimate}}, recieve these parameters if their prior distributions
             are of the same family. Used to quickly set priors for sets of parameters.
}
