% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createParameterVector.R
\name{createParameterVector}
\alias{createParameterVector}
\title{Creates named numeric vector with parameter names for analysis specified by modelText}
\usage{
createParameterVector(modelText)
}
\arguments{
\item{modelText}{A character string that contains the specifications for the model to be run. See \code{\link{blatentSyntax}}
or more information about syntax formatting.}
}
\description{
Creates named numeric vector with parameter names for analysis specified by modelText.
}
\examples{
# Generating parameters for data using Q-matrix structure from data example in Chapter 9 of
#  Rupp, Templin, & Henson (2010).

RTHCh9ModelSyntax = "
   item1 ~ A1
   item2 ~ A2
   item3 ~ A3
   item4 ~ A1 + A2 + A1:A2
   item5 ~ A1 + A3 + A1:A3
   item6 ~ A2 + A3 + A2:A3
   item7 ~ A1 + A2 + A3 + A1:A2 + A1:A3 + A2:A3 + A1:A2:A3

   # Latent Variable Specifications:
  A1 A2 A3 <- latent(unit='rows',distribution='bernoulli',structure='univariate',type='ordinal')

   # Observed Variable Specifications:
   item1-item7 <- observed(distribution = 'bernoulli', link = 'probit')
"
paramVals = createParameterVector(modelText = RTHCh9ModelSyntax)

}
