#' bivarhr: Bivariate Hurdle Regression
#'
#' @description
#' Implements bivariate hurdle regression models using Stan/CmdStan
#' with horseshoe priors, Bayesian Model Averaging via stacking, and
#' comprehensive causal inference methods.
#'
#' @docType package
#' @name bivarhr-package
#' @aliases bivarhr
#'
#' @importFrom stats as.formula binomial coef dnbinom gaussian glm lag
#' @importFrom stats lm model.matrix na.omit p.adjust plogis poisson
#' @importFrom stats quantile rbinom resid rnbinom sd median AIC BIC
#' @importFrom utils capture.output str tail head
#' @importFrom grDevices png dev.copy dev.off
#' @importFrom dplyr `%>%` filter mutate arrange desc slice select transmute bind_rows left_join row_number
#' @importFrom rlang .data
#' @importFrom data.table copy `:=` as.data.table is.data.table fifelse setDTthreads
#' @importFrom tidyr expand_grid
#' @importFrom tibble tibble
#' @importFrom readr write_csv read_csv locale
#' @importFrom cli cli_alert_info cli_alert_success cli_alert_warning cli_h1 cli_h2
#' @importFrom furrr future_map furrr_options
#' @importFrom future plan nbrOfWorkers multisession
#' @importFrom future.apply future_sapply future_lapply
#' @importFrom posterior as_draws_df
#' @importFrom loo loo loo_model_weights
#' @importFrom progressr with_progress progressor handlers
#'
"_PACKAGE"
utils::globalVariables(c(
 
  "dir_csv", "dir_figs", "dir_out", "dir_cmdstan", "dir_rmd",
  
 
  "elpd", "elpd_se", "fit_id", "rank_elpd", "FLOOR", "weight",
  "I_cat", "C_cat", "Regime", "Ic", "Cc", "R",
  "Ic_l1", "Cc_l1", "R_l1",
  "trans_PS", "trans_SF", "trans_FC",
  "..controls", "..x_cols", "..y_cols",
  
 
  "EconCycle", "PopDensity", "Epidemics", "Climate", "War", 
  "t_norm", "t_poly2", "mid_year", "window_years",
  "exposure50", "log_exposure50",
  
 
  "TE_ItoC", "TE_CtoI", "p_ItoC", "p_CtoI", "lag",
  
  
  "C", "I", "zI", "zC",
  
 
  "control_combos", "wb", "hs_idx",
  
 
  ".", ".SD", ".N", ".I", ".GRP", ".BY",
  
 
  "fit_one_internal", "model", "k_grid", "hs_grid", "stan_code"
))
