test_that("Surnames are processed following Census rules", {
    expect_equal(proc_name("SMITH  "), "SMITH")
    expect_equal(proc_name(" García"), "GARCIA")
    expect_equal(proc_name("SMITH-JONES"), "SMITH JONES")
    expect_equal(proc_name("O HARA"), "OHARA")
    expect_equal(proc_name("O'HARA"), "OHARA")
    expect_equal(proc_name("MC CARTAN"), "MCCARTAN")
    expect_equal(proc_name("Mac DONALD"), "MACDONALD")
    expect_equal(proc_name("A A"), NA_character_)
    expect_equal(proc_name("C D"), NA_character_)
    expect_equal(proc_name("S M I T H"), "SMITH")
    expect_equal(proc_name("Smith Jr."), "SMITH")
    expect_equal(proc_name("JONES JUNIOR"), "JONES")
    expect_equal(proc_name("JR SMITH III"), "SMITH")
    expect_equal(proc_name("NASR"), "NASR")
    expect_equal(proc_name("WILSONJR"), "WILSON")
    expect_equal(proc_name("WILSONSR"), "WILSON")
    expect_equal(proc_name("JONES II"), "JONES")
    expect_equal(proc_name("JONES IV"), "JONES")
    expect_equal(proc_name("NISHII"), "NISHII")
    expect_equal(proc_name("GONZALEZ S R"), "GONZALEZ")
    expect_equal(proc_name("AA"), "AA")
    expect_equal(proc_name("AB"), "AB")
    expect_equal(proc_name("BY"), "BY")
    expect_equal(proc_name("BC"), NA_character_)
    expect_equal(proc_name("DECLINE TO STATE"), NA_character_)
})

test_that("Double-barrelled names are detected", {
    expect_true(is_double_name("OCASIO CORTEZ"))
    expect_false(is_double_name("SMITH"))
})
