% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.paired.prop.R
\name{power.paired.prop}
\alias{power.paired.prop}
\title{Calculate the Power and Sample Size for Paired Proportions.}
\usage{
power.paired.prop(
  p1,
  p2,
  n = NULL,
  power = NULL,
  conf.level = 0.95,
  alternative = "two.sided"
)
}
\arguments{
\item{p1}{Numeric, the proportion at the first occasion.}

\item{p2}{Numeric, the proportion at the second occasion.}

\item{n}{Numeric, the sample size.}

\item{power}{Numeric, the desired power (1 - beta). Default is 0.8 when
calculating sample size.}

\item{conf.level}{Numeric, the confidence level (1 - alpha). Default is 0.95.}

\item{alternative}{Character, the type of alternative hypothesis.
Options are 'two.sided' (default) or 'one.sided'.}
}
\value{
A list containing the sample size, power, confidence level, and
alternative hypothesis.
}
\description{
This function calculates either the power given the sample size or the
sample size given the power for paired proportions p1 and p2.
}
\examples{
# Calculate the power given the sample size for paired proportions
power.paired.prop(p1 = 0.1, p2 = 0.15, n = 900)

# Calculate the sample size given the power for paired proportions
power.paired.prop(p1 = 0.15, p2 = 0.1, power = 0.8)
}
\references{
McNemar, Q. (1947). Note on the sampling error of the difference between
correlated proportions or percentages. \emph{Psychometrika}, 12(2), 153-157.
https://doi.org/10.1007/BF02295996.
Connor, R. J. (1987). Sample size for testing differences in proportions for
the paired-sample design. \emph{Biometrics}, 207-211.
https://doi.org/10.2307/2531961.
}
