% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeFeatures.R
\name{shapeFeatures}
\alias{shapeFeatures}
\title{Extraction of Shape Features}
\usage{
shapeFeatures(
  img,
  alpha = 1,
  sigma = 2,
  xdim = 2,
  ydim = 1,
  SOM = FALSE,
  visualize = FALSE
)
}
\arguments{
\item{img}{image (import by \code{\link[imager]{load.image}})}

\item{alpha}{threshold adjustment factor (numeric / 'static' / 'interactive' / 'gaussian')
(from \code{\link[biopixR]{objectDetection}})}

\item{sigma}{smoothing (numeric / 'static' / 'interactive' / 'gaussian')
(from \code{\link[biopixR]{objectDetection}})}

\item{xdim}{x-dimension for the SOM-grid (grid = hexagonal)}

\item{ydim}{y-dimension for the SOM-grid (xdim * ydim = number of neurons)}

\item{SOM}{if TRUE runs SOM algorithm on extracted shape features, grouping
the detected objects}

\item{visualize}{visualizes the groups computed by SOM}
}
\value{
\code{data.frame} containing detailed information about every single object.
}
\description{
This function analyzes the objects detected in an image and calculates
distinct shape characteristics for each object, such as circularity,
eccentricity, radius, and perimeter. The resulting shape attributes can then
be grouped using a Self-Organizing Map (SOM) from the 'Kohonen' package.
}
\examples{
shapeFeatures(
  beads,
  alpha = 1,
  sigma = 0,
  SOM = TRUE,
  visualize = TRUE
)
}
\seealso{
\code{\link[=objectDetection]{objectDetection()}}, \code{\link[=resultAnalytics]{resultAnalytics()}}, \code{\link[kohonen]{som}}
}
