% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorptionAir.R
\name{absorptionAir}
\alias{absorptionAir}
\title{absorptionAir}
\usage{
absorptionAir(f, p, t, h, pr = 101.325, tr = 293.15, to = 273.16)
}
\arguments{
\item{f}{The frequency of the sound source in Hz}

\item{p}{The ambient atmospheric pressure in kPa}

\item{t}{The ambient atmospheric temperature in C}

\item{h}{The relative humidity as a percent}

\item{pr}{The standard pressure at mean sea level}

\item{tr}{The standard temperature in Celcius (293.15 in kelvin)}

\item{to}{The triple-point isotherm temperature}
}
\value{
The sound attenuation rate in dB/m
}
\description{
This function is the standard method of calculating the absorption of sound in air (ISO 9613-1).
}
\examples{
#How much are Malayan tapir calls (15 kHz) absorbed in a tropical region
#(30 deg C) assuming a humidity of 80\% and standard pressure (101.325)?
absorptionAir(15000, 101.325, 30, 80)
}
