% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OTC.R
\name{p.vec.func}
\alias{p.vec.func}
\title{Generate a vector of probabilities for informative group 
testing algorithms.}
\usage{
p.vec.func(p, alpha, grp.sz)
}
\arguments{
\item{p}{overall probability of disease that will be used to 
generate a vector of individual risk probabilities.}

\item{alpha}{a shape parameter for the beta distribution that
specifies the degree of heterogeneity for the generated
probability vector.}

\item{grp.sz}{the number of total individuals for which to 
generate risk probabilities.}
}
\value{
A vector of individual risk probabilities.
}
\description{
Generate a vector of individual risk probabilities
using an overall probability of disease (i.e., the expected 
value of order statistics from a beta distribution)
for use with informative group testing algorithms.
}
\details{
This function uses Michael Black's \code{\link{beta.dist}}
function to generate a vector of individual risk probabilities,
ordered from least to greatest. Depending on the specified 
probability, alpha level, and overall group size, simulation 
may be necessary in order to generate the vector of individual 
probabilities. For this reason, the user should set a seed in
order to reproduce results. The \kbd{p.vec.func} function
augments the \code{\link{beta.dist}} function by checking whether 
simulation is needed before attempting to generate the vector
of individual risk probabilities. See Black et al. (2015)
for additional details on Michael Black's \code{\link{beta.dist}}
function.
}
\examples{
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(8791)
p.vec.func(p=0.03, alpha=0.5, grp.sz=100)

# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(52613)
p.vec.func(p=0.005, alpha=2, grp.sz=40)
}
\references{
\insertRef{Black2015}{binGroup}
}
\seealso{
\code{\link{Informative.array.prob}} for arranging a vector
of individual risk probabilities in a matrix for informative
array testing without master pooling and \code{\link{beta.dist}}
for the function on which \kbd{p.vec.func} is based on.

\url{http://chrisbilder.com/grouptesting/}

Other Individual risk probability functions: 
\code{\link{Informative.array.prob}()},
\code{\link{beta.dist}()}
}
\author{
Brianna D. Hitt
}
\concept{Individual risk probability functions}
