% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddGenericFunctions.R
\name{pmf}
\alias{pmf}
\title{Access the testing probability mass function returned from an object}
\usage{
pmf(object, ...)
}
\arguments{
\item{object}{An object from which the probability mass function is to be extracted.}

\item{...}{Additional arguments to be passed to \code{pmf}.}
}
\description{
\code{pmf} is a generic function that extracts the probability
  mass function from an object (if available) that contains information
  aboout a testing configuration.
}
\examples{
res <- halving(p = rep(0.01, 10), Sp = 1, Se = 1,
               stages = 2, order.p = TRUE)
pmf.halving(res)
}
\seealso{
\code{\link{pmf.halving}} and \code{\link{pmf.Sterrett}}
}
\author{
Christopher R. Bilder
}
