% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2norm.R
\name{estimate_singleThresh_probit}
\alias{estimate_singleThresh_probit}
\title{GLM probit (Single Threshold per Study)}
\usage{
estimate_singleThresh_probit(n_i, c_i, p_i_obs)
}
\arguments{
\item{n_i}{numeric vector}

\item{c_i}{numeric vector}

\item{p_i_obs}{numeric vector}
}
\value{
A list with \code{mu}, \code{sigma}, \code{method="probit"}.
}
\description{
For each group \eqn{i}, we assume the data follows:
\deqn{ \Pr(Y_i = 1) = \Phi\left( \frac{\mu - c_i}{\sigma} \right) }
where \eqn{c_i} is a known threshold, and \eqn{\Phi} is the standard normal CDF (the probit link).
The function reconstructs individual binary outcomes based on observed probabilities,
and estimates the parameters using generalized linear modeling with a probit link.
}
