% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simVAR.R
\name{create_rand_coef_mat}
\alias{create_rand_coef_mat}
\title{Creates a random coefficient matrix}
\usage{
create_rand_coef_mat(
  k,
  p,
  max_abs_eigval = 0.8,
  sparsity_pattern = c("none", "lasso", "hvar"),
  sparsity_options = NULL,
  decay = 0.5,
  ...
)
}
\arguments{
\item{k}{Number of time series}

\item{p}{Number of lags}

\item{max_abs_eigval}{if < 1, then the VAR will be stable}

\item{sparsity_pattern}{The sparsity pattern that should be simulated.
Options are: \code{"none"} for a dense VAR, \code{"lasso"} for a VAR with random zeroes,
and \code{"hvar"} for an elementwise hierarchical sparsity pattern}

\item{sparsity_options}{Named list of additional options for
when sparsity pattern is lasso or hvar. For lasso the option \code{num_zero}
determines the number of zeros. For hvar, the options \code{zero_min} (\code{zero_max})
give the minimum (maximum) of zeroes for each variable in each equation,
and the option \code{zeroes_in_self} (boolean) determines if any of the
coefficients of a variable on itself should be zero.}

\item{decay}{How fast should coefficients shrink when the lag increases.}

\item{...}{Not currently used}
}
\value{
Returns a coefficient matrix in companion form of dimension \code{kp}x\code{kp}.
}
\description{
Creates a random coefficient matrix
}
