% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{pca_spca}
\alias{pca_spca}
\alias{pca_spca_R}
\title{Scalable principal component analysis via streaming power iterations}
\usage{
pca_spca(
  x,
  ncomp = NULL,
  center = TRUE,
  scale = FALSE,
  block_size = 2048L,
  max_iter = 50L,
  tol = 1e-04,
  seed = NULL,
  return_scores = FALSE,
  verbose = FALSE
)

pca_spca(
  x,
  ncomp = NULL,
  center = TRUE,
  scale = FALSE,
  block_size = 2048L,
  max_iter = 50L,
  tol = 1e-04,
  seed = NULL,
  return_scores = FALSE,
  verbose = FALSE
)

pca_spca_R(
  x,
  ncomp = NULL,
  center = TRUE,
  scale = FALSE,
  block_size = 2048L,
  max_iter = 50L,
  tol = 1e-04,
  seed = NULL,
  return_scores = FALSE,
  verbose = FALSE
)

pca_spca(
  x,
  ncomp = NULL,
  center = TRUE,
  scale = FALSE,
  block_size = 2048L,
  max_iter = 50L,
  tol = 1e-04,
  seed = NULL,
  return_scores = FALSE,
  verbose = FALSE
)

pca_spca_R(
  x,
  ncomp = NULL,
  center = TRUE,
  scale = FALSE,
  block_size = 2048L,
  max_iter = 50L,
  tol = 1e-04,
  seed = NULL,
  return_scores = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{x}{A numeric matrix, data frame, \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}}, or an
external pointer referencing a big.matrix. The input is processed in
row-wise blocks so that large matrices can be analysed without creating
dense copies in R memory.}

\item{ncomp}{Number of principal components to retain. Use \code{NULL} or a
non-positive value to keep \code{min(nrow(x), ncol(x))} components.}

\item{center}{Logical; should column means be subtracted before performing
PCA?}

\item{scale}{Logical; when \code{TRUE}, columns are scaled to unit variance after
centring. Scaling requires \code{center = TRUE}.}

\item{block_size}{Number of rows to stream per block when computing column
statistics and matrix-vector products.}

\item{max_iter}{Maximum number of block power iterations.}

\item{tol}{Convergence tolerance applied to the Frobenius norm of the
difference between successive subspace projectors.}

\item{seed}{Optional integer seed used to initialise the random starting
basis.}

\item{return_scores}{Logical; when \code{TRUE}, principal component scores are
computed in a final streaming pass over the data.}

\item{verbose}{Logical; when \code{TRUE}, diagnostic messages describing the
iteration progress are emitted.}
}
\value{
A \code{\link{bigpca}} object containing the approximate PCA solution with the
same structure as \code{\link[=pca_bigmatrix]{pca_bigmatrix()}}. The result includes component standard
deviations, rotation/loadings, optional scores, column statistics, and
variance summaries. Additional metadata is stored in
\code{attr(result, "iterations")} (number of iterations performed),
\code{attr(result, "tolerance")} (requested tolerance), and
\code{attr(result, "converged")} (logical convergence flag).

A \code{\link{bigpca}} object containing the approximate PCA solution with the
same structure as \code{\link[=pca_bigmatrix]{pca_bigmatrix()}}. The result includes component standard
deviations, rotation/loadings, optional scores, column statistics, and
variance summaries. Additional metadata is stored in
\code{attr(result, "iterations")} (number of iterations performed),
\code{attr(result, "tolerance")} (requested tolerance), and
\code{attr(result, "converged")} (logical convergence flag).

A \code{\link{bigpca}} object containing the approximate PCA solution with the
same structure as \code{\link[=pca_bigmatrix]{pca_bigmatrix()}}. The result includes component standard
deviations, rotation/loadings, optional scores, column statistics, and
variance summaries. Additional metadata is stored in
\code{attr(result, "iterations")} (number of iterations performed),
\code{attr(result, "tolerance")} (requested tolerance), and
\code{attr(result, "converged")} (logical convergence flag).
}
\description{
Implements the scalable PCA (sPCA) procedure of Elgamal et al. (2015), which
uses block power iterations to approximate the leading principal components
while streaming the data in manageable chunks. The algorithm only requires
matrix-vector products, allowing large matrices to be processed without
materialising the full cross-product in memory.

Implements the scalable PCA (sPCA) procedure of Elgamal et al. (2015), which
uses block power iterations to approximate the leading principal components
while streaming the data in manageable chunks. The algorithm only requires
matrix-vector products, allowing large matrices to be processed without
materialising the full cross-product in memory.

Implements the scalable PCA (sPCA) procedure of Elgamal et al. (2015), which
uses block power iterations to approximate the leading principal components
while streaming the data in manageable chunks. The algorithm only requires
matrix-vector products, allowing large matrices to be processed without
materialising the full cross-product in memory.
}
\references{
Tarek Elgamal, Maysam Yabandeh, Ashraf Aboulnaga, Waleed Mustafa, and Mohamed
Hefeeda (2015). \emph{sPCA: Scalable Principal Component Analysis for Big Data on
Distributed Platforms}. Proceedings of the 2015 ACM SIGMOD International
Conference on Management of Data. \url{doi:10.1145/2723372.2751520}.

Tarek Elgamal, Maysam Yabandeh, Ashraf Aboulnaga, Waleed Mustafa, and Mohamed
Hefeeda (2015). \emph{sPCA: Scalable Principal Component Analysis for Big Data on
Distributed Platforms}. Proceedings of the 2015 ACM SIGMOD International
Conference on Management of Data. \url{doi:10.1145/2723372.2751520}.

Tarek Elgamal, Maysam Yabandeh, Ashraf Aboulnaga, Waleed Mustafa, and Mohamed
Hefeeda (2015). \emph{sPCA: Scalable Principal Component Analysis for Big Data on
Distributed Platforms}. Proceedings of the 2015 ACM SIGMOD International
Conference on Management of Data. \url{doi:10.1145/2723372.2751520}.
}
