% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class022-bids_file_entity_parser.R
\name{parse_path_bids_entity}
\alias{parse_path_bids_entity}
\title{Parse 'BIDS' entities from file path}
\usage{
parse_path_bids_entity(
  path,
  auto_cache = TRUE,
  schema_key = NA,
  bids_version = current_bids_version()
)
}
\arguments{
\item{path}{path to the entity file, recommended to input the absolute path
or relative path from the 'BIDS' root directory}

\item{auto_cache}{whether to automatically cache the class definition to
speed to next time; default is true}

\item{schema_key}{'BIDS' schema key if explicit entity rules is needed}

\item{bids_version}{'BIDS' version to query the entity rules}
}
\value{
A \code{'BIDSEntityFile'} instance.
}
\description{
Parse 'BIDS' entities from file path
}
\examples{


path <- "anat/sub-01_chunk-001_t1w.nii.gz"

# --- parse ------------------------------------------------
parsed_filename <- parse_path_bids_entity(path)
parsed_filename

parsed_filename$get_bids_entity("sub")

# alternatively
parsed_filename$entities$sub$value

# data type is `anat` imaging
parsed_filename$data_type

# data is T1-weighted
parsed_filename$suffix

# --- usage ------------------------------------------------
# use it as character
file.path("/path/to/bids/dir/sub-01", parsed_filename)

# modify
parsed_filename$entities$task <- "special"

# new file path: anat/sub-01_task-special_chunk-001_T1w.nii.gz
parsed_filename

# ---- schema -----------------------------------------------
# get BIDS entity rules
parsed_filename$get_bids_entity("task")

# get entity rules
parsed_filename$get_bids_entity_rules()


}
\author{
Zhengjia Wang
}
