% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coupling_similarity.R
\name{coupling_similarity}
\alias{coupling_similarity}
\title{Calculating the Coupling Similarity Measure for Edges}
\usage{
coupling_similarity(
  dt,
  source,
  ref,
  weight_threshold = 1,
  output_in_character = TRUE
)
}
\arguments{
\item{dt}{The table with citing and cited documents.}

\item{source}{The column name of the source identifiers, that is the documents that are citing. In bibliographic coupling, these documents are the nodes of the network.}

\item{ref}{The column name of the references that are cited.}

\item{weight_threshold}{Corresponds to the value of the non-normalized weights of edges. The function just keeps the edges
that have a non-normalized weight superior to the \code{weight_threshold}. In other words, if you set the
parameter to 2, the function keeps only the edges between nodes that share at least two references
in common in their bibliography. In a large bibliographic coupling network,
you can consider for instance that sharing only one reference is not sufficient/significant for two articles to be linked together.
This parameter could also be modified to avoid creating intractable networks with too many edges.}

\item{output_in_character}{If TRUE, the function ends by transforming the \code{from} and \code{to} columns in character, to make the
creation of a \href{https://tidygraph.data-imaginist.com/index.html}{tidygraph} network easier.}
}
\value{
A data.table with the articles identifiers in \code{from} and \code{to} columns, with the similarity measure in
another column. It also keeps a copy of \code{from} and \code{to} in the \code{Source} and \code{Target} columns. This is useful is you
are using the tidygraph package then, where \code{from} and \code{to} values are modified when creating a graph.
}
\description{
This function calculates a refined similarity measure of coupling links, from a direct citation data frame.
It is sinpired by \insertCite{shen2019}{biblionetwork}. To a certain extent, it mixes the \code{\link[=coupling_strength]{coupling_strength()}} function with
the cosine measure of the \code{\link[=biblio_coupling]{biblio_coupling()}} function.
}
\details{
The function use the following formalisation:

\deqn{\frac{R_{S}(A) \bullet R_{S}(B)}{\sqrt{R_{S}(A).R_{S}(B)}}}
\enumerate{
\item with \deqn{R_{S}(A) \bullet R_{S}(B) = \sum_{j}\sqrt{log({\frac{N}{freq(R_{j})}})}} that is a measure similar to the coupling strength measure;
\item and \deqn{R_{S}(A).R_{S}(B) = \sum_{j}\sqrt{log({\frac{N}{freq(R_{j}(A))}})} . \sum_{j}\sqrt{log({\frac{N}{freq(R_{j}(B))}})}} which is the separated
sum for each article of the normalized value of a citation. It is the cosine measure of documents A and B but adapted to the spirit of the
coupling strength.
}
}
\examples{
library(biblionetwork)
coupling_similarity(Ref_stagflation,
source = "Citing_ItemID_Ref",
ref = "ItemID_Ref")

}
\references{
\insertAllCited{}
}
