% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_heatmap.R
\name{visualize_heatmap}
\alias{visualize_heatmap}
\title{Visualize Topic Similarity Heatmap using BERTopic}
\usage{
visualize_heatmap(
  model,
  filename = "topics_similarity_heatmap",
  auto_open = FALSE
)
}
\arguments{
\item{model}{A BERTopic model object. The model must have the method \code{visualize_heatmap}.}

\item{filename}{A character string specifying the name of the HTML file to save the visualization.
The default value is "topics_similarity_heatmap". The filename should not contain illegal characters.
The \code{.html} extension is added automatically if not provided.}

\item{auto_open}{Logical. If TRUE, opens the HTML file after saving. Default is FALSE.}
}
\value{
The function does not return a value but saves an HTML file containing the visualization
and displays it in the current R environment.
}
\description{
This function visualizes the topic similarity heatmap of topics from a BERTopic model using Python's Plotly library.
The visualization is saved as an interactive HTML file, which can be opened and viewed in a web browser.
}
\examples{
\donttest{
if (exists("topic_model")) {
  visualize_heatmap(model = topic_model, filename = "topics_similarity_heatmap", auto_open = FALSE)
} else {
  message("No topic_model found. Please train or load a model first.")
}
}
}

