% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindUrlPipe.R
\name{FindUrlPipe}
\alias{FindUrlPipe}
\title{Class to find and/or remove the URLs on the data field of an Instance}
\description{
This class is responsible of detecting the existing URLs in the
\strong{data} field of each \code{\link{Instance}}. Identified URLs are
stored inside the \strong{URLs} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline URLs removement.
}
\section{Details}{

The regular expressions indicated in the \code{URLPatterns}
variable are used to identify URLs.
}

\section{Note}{

\code{\link{FindUrlPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{FindUrlPipe}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URLPattern}}{A \code{\link{character}} value. The regular
expression to detect URLs.}

\item{\code{EmailPattern}}{A \code{\link{character}} value. The regular expression to detect emails.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FindUrlPipe-new}{\code{FindUrlPipe$new()}}
\item \href{#method-FindUrlPipe-pipe}{\code{FindUrlPipe$pipe()}}
\item \href{#method-FindUrlPipe-findUrl}{\code{FindUrlPipe$findUrl()}}
\item \href{#method-FindUrlPipe-removeUrl}{\code{FindUrlPipe$removeUrl()}}
\item \href{#method-FindUrlPipe-putNamesURLPattern}{\code{FindUrlPipe$putNamesURLPattern()}}
\item \href{#method-FindUrlPipe-getURLPatterns}{\code{FindUrlPipe$getURLPatterns()}}
\item \href{#method-FindUrlPipe-setURLPatterns}{\code{FindUrlPipe$setURLPatterns()}}
\item \href{#method-FindUrlPipe-getNamesURLPatterns}{\code{FindUrlPipe$getNamesURLPatterns()}}
\item \href{#method-FindUrlPipe-setNamesURLPatterns}{\code{FindUrlPipe$setNamesURLPatterns()}}
\item \href{#method-FindUrlPipe-clone}{\code{FindUrlPipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{FindUrlPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$new(
  propertyName = "URLs",
  alwaysBeforeDeps = list(),
  notAfterDeps = list("FindUrlPipe"),
  removeUrls = TRUE,
  URLPatterns = list(self$URLPattern, self$EmailPattern),
  namesURLPatterns = list("UrlPattern", "EmailPattern")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{removeUrls}}{A \code{\link{logical}} value. Indicates if the
URLs are removed.}

\item{\code{URLPatterns}}{A \code{\link{list}} value. The regex to find URLs.}

\item{\code{namesURLPatterns}}{A \code{\link{list}} value. The names of regex.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/remove
the URLs. The URLs found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-findUrl"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-findUrl}{}}}
\subsection{Method \code{findUrl()}}{
Finds the \emph{URLs} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$findUrl(pattern, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{A \code{\link{character}} value. The regex to find URLs.}

\item{\code{data}}{A \code{\link{character}} value. The text to find the URLs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{list}} with URLs found.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-removeUrl"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-removeUrl}{}}}
\subsection{Method \code{removeUrl()}}{
Removes \emph{the URL} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$removeUrl(pattern, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{A \code{\link{character}} value. The regex to find URLs.}

\item{\code{data}}{A \code{\link{character}} value. The text to remove the URLs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with URLs removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-putNamesURLPattern"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-putNamesURLPattern}{}}}
\subsection{Method \code{putNamesURLPattern()}}{
Sets the names to \emph{URL patterns} result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$putNamesURLPattern(resultOfURLPatterns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resultOfURLPatterns}}{A \code{\link{list}} value. The list with
URLs found.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The URLs found with the names of URL pattern.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-getURLPatterns"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-getURLPatterns}{}}}
\subsection{Method \code{getURLPatterns()}}{
Gets \emph{the URL patterns}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$getURLPatterns()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of \emph{URL patterns}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-setURLPatterns"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-setURLPatterns}{}}}
\subsection{Method \code{setURLPatterns()}}{
Sets the \emph{URL patterns}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$setURLPatterns(URLPatterns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{URLPatterns}}{A \code{\link{list}} value. The new value of
the URL patterns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-getNamesURLPatterns"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-getNamesURLPatterns}{}}}
\subsection{Method \code{getNamesURLPatterns()}}{
Gets the \emph{names of URLs}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$getNamesURLPatterns()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of names of URLs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-setNamesURLPatterns"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-setNamesURLPatterns}{}}}
\subsection{Method \code{setNamesURLPatterns()}}{
Sets the \emph{names of URLs}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$setNamesURLPatterns(namesURLPatterns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{namesURLPatterns}}{A \code{\link{list}} value. The new value of
the names of URLs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindUrlPipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FindUrlPipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindUrlPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
