% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableOpenXlsxStyles.R
\docType{class}
\name{TableOpenXlsxStyles}
\alias{TableOpenXlsxStyles}
\title{R6 class that defines a collection of Excel styles as used by the `openxlsx`
package.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
The `TableOpenXlsxStyles` class stores a collection of `TableTableOpenXlsx`
style objects.
}
\examples{
# This class should not be used by end users.  It is an internal class
# created only by the BasicTable class.  It is used when rendering to Excel.
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
library(openxlsx)
wb <- createWorkbook(creator = Sys.getenv("USERNAME"))
addWorksheet(wb, "Data")
tbl$writeToExcelWorksheet(wb=wb, wsName="Data",
                         topRowNumber=1, leftMostColumnNumber=1,
                         applyStyles=TRUE, mapStylesFromCSS=TRUE)
# Use saveWorkbook() to save the Excel file.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{count}}{The number of styles in the collection.}

\item{\code{styles}}{A list of `TableOpenXlsxStyle` objects that comprise the collection.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TableOpenXlsxStyles-new}{\code{TableOpenXlsxStyles$new()}}
\item \href{#method-TableOpenXlsxStyles-clearStyles}{\code{TableOpenXlsxStyles$clearStyles()}}
\item \href{#method-TableOpenXlsxStyles-findNamedStyle}{\code{TableOpenXlsxStyles$findNamedStyle()}}
\item \href{#method-TableOpenXlsxStyles-findOrAddStyle}{\code{TableOpenXlsxStyles$findOrAddStyle()}}
\item \href{#method-TableOpenXlsxStyles-addNamedStyles}{\code{TableOpenXlsxStyles$addNamedStyles()}}
\item \href{#method-TableOpenXlsxStyles-asList}{\code{TableOpenXlsxStyles$asList()}}
\item \href{#method-TableOpenXlsxStyles-asJSON}{\code{TableOpenXlsxStyles$asJSON()}}
\item \href{#method-TableOpenXlsxStyles-asString}{\code{TableOpenXlsxStyles$asString()}}
\item \href{#method-TableOpenXlsxStyles-clone}{\code{TableOpenXlsxStyles$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-new"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-new}{}}}
\subsection{Method \code{new()}}{
Create a new `TableOpenXlsxStyles` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$new(parentTable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentTable}}{Owning table.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-clearStyles"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-clearStyles}{}}}
\subsection{Method \code{clearStyles()}}{
Clear the collection removing all styles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$clearStyles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-findNamedStyle"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-findNamedStyle}{}}}
\subsection{Method \code{findNamedStyle()}}{
Find a style in the collection matching the specified base style name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$findNamedStyle(baseStyleName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{baseStyleName}}{The style name to find.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A `TableTableOpenXlsx` object that is the style matching the
  specified base style name or `NULL` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-findOrAddStyle"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-findOrAddStyle}{}}}
\subsection{Method \code{findOrAddStyle()}}{
Find a style in the collection matching the specified base style name and
style properties.  If there is no matching style, then optionally add a
new style.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$findOrAddStyle(
  action = "findOrAdd",
  baseStyleName = NULL,
  isBaseStyle = NULL,
  style = NULL,
  mapFromCss = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{action}}{The action to carry out.  Must be one of "find", "add" or
"findOrAdd" (default).}

\item{\code{baseStyleName}}{The style name to find/add.}

\item{\code{isBaseStyle}}{Is the style to be found/added a base style?}

\item{\code{style}}{A `TableStyle` object specifying style properties to be found/added.}

\item{\code{mapFromCss}}{`TRUE` (default) to map the basictabler CSS styles to
corresponding Excel styles, `FALSE` to apply only the specified xl
styles.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A `TableTableOpenXlsx` object that is the style matching the
  specified base style name or `NULL` otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-addNamedStyles"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-addNamedStyles}{}}}
\subsection{Method \code{addNamedStyles()}}{
Populate the OpenXlsx styles
  based on the styles defined in the table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$addNamedStyles(mapFromCss = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mapFromCss}}{`TRUE` (default) to map the basictabler CSS styles to
corresponding Excel styles, `FALSE` to apply only the specified xl
styles.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-asList"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of this object as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of this object as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-asString"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-asString}{}}}
\subsection{Method \code{asString()}}{
Return the contents of this object as a string for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$asString(seperator = ", ")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{seperator}}{Delimiter used to combine multiple values into a string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TableOpenXlsxStyles-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TableOpenXlsxStyles-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TableOpenXlsxStyles$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
