% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractTreeData.R
\name{extractTreeData}
\alias{extractTreeData}
\title{extractTreeData}
\usage{
extractTreeData(model, data)
}
\arguments{
\item{model}{Model created from either the BART, dbarts or bartMachine packages.}

\item{data}{a data frame used to build the BART model.}
}
\value{
A list containing the extracted and processed tree data. This list includes:
\enumerate{
  \item \strong{Tree Data Frame}: A data frame containing tree attributes.
  \item \strong{Variable Name}: The names of the variables used in building the model.
  \item \strong{nMCMC}: The total number of iterations (posterior draws) after burn-in.
  \item \strong{nTree}: The total number of trees grown in the sum-of-trees model.
  \item \strong{nVar}: The total number of covariates used in the model.
}
The object created by the `extractTreeData` function encompasses these elements,
facilitating detailed analysis and visualisation of BART model components.
}
\description{
Creates a list of all tree attributes for a model
created by either the BART, dbarts or bartMachine packages.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
# Load the dbarts package to access the bart function
library(dbarts)
# Get Data
df <- na.omit(airquality)
# Create Simple dbarts Model For Regression:
set.seed(1701)
dbartModel <- bart(df[2:6], df[,1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)
# Tree Data
trees_data <- extractTreeData(model = dbartModel, data = df)
}

}
