% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{config_setup}
\alias{config_setup}
\title{Create a JSON config file}
\usage{
config_setup(apikey, companyname, conffile, verbose = TRUE)
}
\arguments{
\item{apikey}{API key to access the bambooHR API. User will be prompted to enter one if not supplied}

\item{companyname}{This is the subdomain used to access BambooHR. If you access BambooHR at https://mycompany.bamboohr.com, then companyname will be "mycompany"}

\item{conffile}{A string giving the path where the configuration file will be written.
This will automatically attempt to load from the default location \code{~/.bambooHR_user_config.json} (which can be changed via a \code{bambooHR.config_file}) entry in \code{options}).}

\item{verbose}{whether to print path of conf file used, passed to use_config}
}
\description{
Create a JSON config file
}
\examples{
\dontrun{
config_setup("secret api key", "cool company")
}

}
