% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{read_one_bt_activity_file}
\alias{read_one_bt_activity_file}
\title{Read One 'BabyTime' Activity File}
\usage{
read_one_bt_activity_file(infile, list_db = NULL, verbose = FALSE)
}
\arguments{
\item{infile}{a .zip or .txt file with the format activity_BabyName_yyyymm
as the 'BabyTime' app exports data.}

\item{list_db}{a `Raw BT List DB` object on which to append data. If none exists, this
will create a new `Raw BT List DB` object.}

\item{verbose}{whether or not to write out progress messages.}
}
\value{
a populated `Raw BT List DB` object
}
\description{
Read line-by-line and parse into a "database" in a list.
}
\examples{
data_dir <- system.file('extdata', package = 'babyTimeR')
baby_dann_db <- read_one_bt_activity_file(
  infile = file.path(data_dir, 'activity_Dann_202411.txt')
) |>
    clean_bt_list_db()
names(baby_dann_db)
}
