% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStdC.R
\name{plotStdC}
\alias{plotStdC}
\title{Plot Silica Concentrations vs. Absorbance}
\usage{
plotStdC(
  concentration,
  absorbance,
  title = "Concentration vs. Absorbance",
  xlab = "Absorbance",
  ylab = "Concentration (Millimoles)"
)
}
\arguments{
\item{concentration}{A numeric vector of concentration values.}

\item{absorbance}{A numeric vector of absorbance values.}

\item{title}{A character string for the plot title.}

\item{xlab}{A character string for the x-axis label.}

\item{ylab}{A character string for the y-axis label.}
}
\value{
A list with components:
\itemize{
\item intercept: The y-intercept of the fitted line.
\item rsquared: The R-squared value of the fitted line.
\item equation : The equation of the fitted line in the form y=mx+C
}
}
\description{
This function plots the Standard Calibration curves from known concentration of silica in standard solutions against absorbance
values from spectrophotometer analysis. It takes Silica concentration values as Y argument and their absorbance values from spectrophotometer
as X argument then creates a scatter plot, fits a line of best fit, and returns the y-intercept and R-squared values.
}
\examples{

concentration <- c(1, 2, 3, 4, 5)
absorbance <- c(0.1, 0.3, 0.6, 0.8, 1.2)
plotStdC(concentration, absorbance,
          title = "Concentration vs. Absorbance",
          xlab = "Absorbance",
          ylab = "Concentrations")

}
