% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.R
\name{flux}
\alias{flux}
\title{Calculate bSi fluxes based on pbSi (percent bSi) and MARS}
\usage{
flux(pbSi = NULL, MARS = NULL, data_file = NULL, output_csv_file = NULL)
}
\arguments{
\item{pbSi}{Numeric vector of percent biogenic silica.}

\item{MARS}{Numeric vector of sediment mass accumulation rates.}

\item{data_file}{Path to a CSV file containing data with columns 'pbSi' and 'MARS'.}

\item{output_csv_file}{Path to save the calculated flux values as a CSV file.}
}
\value{
A data frame with input values and calculated flux.
}
\description{
Calculate bSi fluxes based on pbSi (percent bSi) and MARS
}
\examples{

#Example 1: Using vectors
flux_values <- flux(pbSi = c(2, 5, 8), MARS = c(10, 15, 20),
output_csv_file = tempfile("flux_output1.csv"))
#Example 2: Using data from a file
data_file <- system.file("extdata", "example_data.csv", package = "bSi")
flux_values <- flux(data_file = data_file, output_csv_file = tempfile("flux_output2.csv"))

}
