% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{r_environment}
\alias{r_environment}
\title{Create an environment}
\usage{
r_environment(
  name,
  version = NULL,
  environment_variables = NULL,
  r_version = NULL,
  rscript_path = NULL,
  snapshot_date = NULL,
  cran_packages = NULL,
  github_packages = NULL,
  custom_url_packages = NULL,
  bioconductor_packages = NULL,
  custom_docker_image = NULL,
  image_registry_details = NULL,
  use_gpu = FALSE,
  shm_size = NULL
)
}
\arguments{
\item{name}{A string of the name of the environment.}

\item{version}{A string of the version of the environment.}

\item{environment_variables}{A named list of environment variables names
and values. These environment variables are set on the process where the user
script is being executed.}

\item{r_version}{The version of R to be installed.}

\item{rscript_path}{The Rscript path to use if an environment build is not required.
The path specified gets used to call the user script.}

\item{snapshot_date}{Date of MRAN snapshot to use.}

\item{cran_packages}{A list of \code{cran_package} objects to be installed.}

\item{github_packages}{A list of \code{github_package} objects to be installed.}

\item{custom_url_packages}{A character vector of packages to be installed
from local directory or custom URL.}

\item{bioconductor_packages}{A character vector of packages to be installed
from Bioconductor.}

\item{custom_docker_image}{A string of the name of the Docker image from
which the image to use for training or deployment will be built. If not set,
a predefined Docker image will be used. To use an image from a private Docker
repository, you will also have to specify the \code{image_registry_details} parameter.}

\item{image_registry_details}{A \code{ContainerRegistry} object of the details of
the Docker image registry for the custom Docker image.}

\item{use_gpu}{Indicates whether the environment should support GPUs.
If \code{TRUE}, a predefined GPU-based Docker image will be used in the environment.
If \code{FALSE}, a predefined CPU-based image will be used. Predefined Docker images
(CPU or GPU) will only be used if the \code{custom_docker_image} parameter is not set.}

\item{shm_size}{A string for the size of the Docker container's shared
memory block. For more information, see
\href{https://docs.docker.com/engine/reference/run/}{Docker run reference}
If not set, a default value of \code{'2g'} is used.}
}
\value{
The \code{Environment} object.
}
\description{
Configure the R environment to be used for training or web service
deployments. When you submit a run or deploy a model, Azure ML builds a
Docker image and creates a conda environment with your specifications from
your \code{Environment} object within that Docker container.

If the \code{custom_docker_image} parameter
is not set, Azure ML will build a predefined base image (CPU or GPU
depending on the \code{use_gpu} flag) and install any R packages specified in the
\code{cran_packages}, \code{github_packages}, or \code{custom_url_packages} parameters.
}
\section{Details}{

Once built, the Docker image appears in the Azure Container Registry
associated with your workspace, by default. The repository name has the form
\emph{azureml/azureml_<uuid>}. The unique identifier (\emph{uuid}) part corresponds to
a hash computed from the environment configuration. This allows the service
to determine whether an image corresponding to the given environment already
exists for reuse.

If you make changes to an existing environment, such as adding an R package,
a new version of the environment is created when you either submit a run,
deploy a model, or manually register the environment. The versioning allows
you to view changes to the environment over time.
}

\section{Predefined Docker images}{

When submitting a training job or deploying a model, Azure ML runs your
training script or scoring script within a Docker container. If no custom
Docker image is specified with the \code{custom_docker_image} parameter, Azure
ML will build a predefined CPU or GPU Docker image. The predefine images extend
the Ubuntu 16.04 \href{https://github.com/Azure/AzureML-Containers}{Azure ML base images}
and include the following dependencies:
\tabular{rrr}{
\strong{Dependencies} \tab \strong{Version} \tab \strong{Remarks}\cr
azuremlsdk \tab latest \tab (from GitHub)\cr
R \tab 3.6.0 \tab -\cr
Commonly used R packages \tab - \tab 80+ of the most popular R packages for
data science, including the IRKernel, dplyr, shiny, ggplot2, tidyr, caret,
and nnet. For the full list of packages included, see
\href{https://github.com/Azure/azureml-sdk-for-r/blob/master/misc/r-packages-docker.md}{here}.\cr
Python \tab 3.7.0 \tab -\cr
azureml-defaults \tab latest \tab \code{azureml-defaults} contains the
\code{azureml-core} and \code{applicationinsights} packages of the Python SDK that
are required for tasks such as logging metrics, uploading artifacts, and
deploying models. (from pip)\cr
rpy2 \tab latest \tab (from conda)\cr
CUDA (GPU image only) \tab 10.0 \tab CuDNN (version 7) is also included
}
}

\examples{
# The following example defines an environment that will build the default
# base CPU image.
\dontrun{
r_env <- r_environment(name = 'myr_env',
                       version = '1')
}
}
\seealso{
\code{estimator()}, \code{inference_config()}
}
