% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_function.R
\name{create_function}
\alias{create_function}
\alias{update_function_code}
\alias{update_function_config}
\alias{update_function}
\alias{publish_function_version}
\alias{make_function_version}
\title{Manage AWS Lambda Functions}
\usage{
create_function(
  name,
  func,
  handler,
  role,
  runtime = c("nodejs12.x", "nodejs10.x", "java11", "java8", "python3.8", "python3.7",
    "python3.6", "python2.7", "dotnetcore3.1", "dotnetcore2.1", "go1.x", "ruby2.7",
    "ruby2.5", "provided"),
  timeout = 3L,
  description,
  ...
)

update_function_code(name, func, ...)

update_function_config(
  name,
  description,
  handler,
  role,
  runtime = c("nodejs12.x", "nodejs10.x", "java11", "java8", "python3.8", "python3.7",
    "python3.6", "python2.7", "dotnetcore3.1", "dotnetcore2.1", "go1.x", "ruby2.7",
    "ruby2.5", "provided"),
  timeout = 3L,
  ...
)

update_function(
  name,
  func,
  description,
  handler,
  role,
  runtime = c("nodejs12.x", "nodejs10.x", "java11", "java8", "python3.8", "python3.7",
    "python3.6", "python2.7", "dotnetcore3.1", "dotnetcore2.1", "go1.x", "ruby2.7",
    "ruby2.5", "provided"),
  timeout = 3L,
  ...
)

publish_function_version(name, description, ...)

make_function_version(name, description, ...)
}
\arguments{
\item{name}{A character string specifying the function name (either a full ARN or a max 64-character string). For functions other than \code{create_function} this can also be an object of class \dQuote{aws_lambda_function}.}

\item{func}{Either (1) a character string containing a url-style AWS S3
bucket and object key (e.g., \code{"s3://bucketname/objectkey"}) where the
object is the .zip file containing the AWS Lambda deployment package; (2) a
file string pointing to a .zip containing the deployment package; or (3) a
single file (e.g., a javascript file) that will be zipped and used as the
deployment. The third option is merely a convenience for very simple
deployment packages.}

\item{handler}{A character string specifying the function within your code
that Lambda calls to begin execution.}

\item{role}{A character string containing an IAM role or an object of class
\dQuote{iam_role}. This is the role that is used when the function is
invoked, so it must have permissions over any AWS resources needed by the
function.}

\item{runtime}{A character string specifying the runtime environment for the
function.}

\item{timeout}{An integer specifying the timeout for the function, in
seconds.}

\item{description}{Optionally, a max 256-character description of the
function for your own use.}

\item{\dots}{Additional arguments passed to \code{\link{lambdaHTTP}}.}
}
\value{
A list of class \dQuote{aws_lambda_function}.
}
\description{
Create, update, and version AWS Lambda functions
}
\details{
\code{create_function} creates a new function from a deployment
  package. \code{update_function_code} updates the code within a function.
  \code{update_function_config} updates the configuration settings of a
  function. \code{publish_function_version} records a function version (see
  \code{\link{list_function_versions}}; changes made between versioning are
  not recorded.
}
\examples{
\dontrun{
# 'hello world!' example code
hello <- system.file("templates", "helloworld.js", package = "aws.lambda")

# get IAM role for Lambda execution
library("aws.iam")
id <- get_caller_identity()[["Account"]]
# Note: This role may not work. We recommend copying the ARN of a
# Lambda-capable role from the console once until we're able to more
# smoothly integrate with aws.iam.
role <- paste0("arn:aws:iam::", id, ":role/lambda_basic_execution")

lambda_func <- create_function("helloworld",
  func = hello,
  handler = "helloworld.handler",
  role = role
)

# invoke function
invoke_function(lambda_func)

# delete function
delete_function(lambda_func)
}
}
\references{
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html}{API
Reference: CreateFunction}
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionCode.html}{API
Reference: UpdateFunctionCode}
\href{https://docs.aws.amazon.com/lambda/latest/dg/API_PublishVersion.html}{API
Reference: PublishVersion}
}
\seealso{
\code{\link{invoke_function}}, \code{\link{create_function_alias}},
  \code{\link{list_functions}}, \code{\link{delete_function}}
}
