% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision.R
\name{import_review}
\alias{import_review}
\title{Decision management}
\source{
inspired by \code{\link[testthat:snapshot_accept]{testthat::snapshot_review()}}
}
\usage{
import_review(
  source_path = "R/",
  output_path = get_target_dir(),
  background = getOption("autoimport_background", FALSE)
)
}
\arguments{
\item{source_path}{path to the original R files}

\item{output_path}{path to the updated R files}

\item{background}{whether to run the app in a background process. Default to \code{getOption("autoimport_background", FALSE)}.}
}
\value{
nothing if \code{background==FALSE}, the (\link[callr:reexports]{callr::process}) object if \code{background==TRUE}
}
\description{
Opens a Shiny app that shows a visual diff of each modified file.
}
\section{Warning}{

Beware that using \code{background=TRUE} can bloat your system with multiple R session! \cr
You should probably kill the process when you are done:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{p=import_review(background=TRUE)
p$kill()
}\if{html}{\out{</div>}}
}

