% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustedPlot.R
\name{adjustedPlot}
\alias{adjustedPlot}
\title{Draw an expected plot}
\usage{
adjustedPlot(
  fit,
  xnames = NULL,
  pred.values = list(),
  newdata = NULL,
  maxy.lev = 5,
  median = TRUE,
  facet = NULL,
  se = FALSE,
  mark.time = FALSE,
  show.median = FALSE,
  type = "ggplot",
  ...
)
}
\arguments{
\item{fit}{An object of class "coxph" or "survreg"}

\item{xnames}{Character Names of explanatory variable to plot}

\item{pred.values}{A list A list of predictor values}

\item{newdata}{A data.frame or NULL}

\item{maxy.lev}{Integer Maximum unique length of a numeric variable to be treated as categorical variables}

\item{median}{Logical}

\item{facet}{Character Name of facet variable}

\item{se}{logical Whether or not show se}

\item{mark.time}{logical Whether or not mark time}

\item{show.median}{logical}

\item{type}{Character plot type}

\item{...}{further arguments to be passed to plot.survfit}
}
\value{
A ggplot or no return value(called for side effects)
}
\description{
Draw an expected plot
}
\examples{
library(survival)
fit=coxph(Surv(time,status)~rx+logWBC,data=anderson)
adjustedPlot(fit)
adjustedPlot(fit,xnames="rx",se=TRUE,type="plot")
adjustedPlot(fit,xnames="rx",se=TRUE)
\dontrun{
anderson$WBCgroup=ifelse(anderson$logWBC<=2.73,0,1)
anderson$WBCgroup=factor(anderson$WBCgroup,labels=c("low","high"))
anderson$rx=factor(anderson$rx,labels=c("treatment","control"))
fit=coxph(Surv(time,status)~rx,data=anderson)
adjustedPlot(fit,xnames=c("rx"),show.median=TRUE)
fit=coxph(Surv(time,status)~rx*WBCgroup,data=anderson)
adjustedPlot(fit,xnames=c("rx","WBCgroup"),show.median=TRUE)
adjustedPlot(fit,xnames=c("rx","WBCgroup"),facet="WBCgroup",show.median=TRUE)
data(cancer,package="survival")
fit=coxph(Surv(time,status)~rx+strata(sex)+age+differ,data =colon)
adjustedPlot(fit,xnames=c("sex"))
adjustedPlot(fit,xnames=c("sex"),pred.values=list(age=58,differ=3))
adjustedPlot(fit,xnames=c("sex","rx"),facet="sex")
adjustedPlot(fit,xnames=c("rx","sex","differ"),facet=c("sex","rx"),se=TRUE)
fit <- coxph(Surv(start, stop, event) ~ rx + number + size+ cluster(id), data = bladder2)
adjustedPlot(fit,xnames=c("rx","number","size"),facet=c("rx","size"),maxy.lev=8)
}
}
