% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_lift.R
\name{plotD3_lift}
\alias{plotD3_lift}
\alias{plotD3LIFT}
\title{Plot LIFT in D3 with r2d3 package.}
\usage{
plotD3_lift(object, ..., scale_plot = FALSE, zeros = TRUE)

plotD3LIFT(object, ..., scale_plot = FALSE)
}
\arguments{
\item{object}{An object of class 'auditor_model_evaluation' created with \code{\link{model_evaluation}} function.}

\item{...}{Other 'auditor_model_evaluation' objects to be plotted together.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's FALSE.}

\item{zeros}{Logical. It makes the lines start from the \code{(0,0)} point. By default it's \code{TRUE}.}
}
\value{
a \code{r2d3} object
}
\description{
LIFT is a plot of the rate of positive prediction against true positive rate for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
eva_glm <- model_evaluation(glm_audit)

# plot results
plot_roc(eva_glm)
plot(eva_glm)

#add second model
model_glm_2 <- glm(survived ~ .-age, family = binomial, data = titanic_imputed)
glm_audit_2 <- audit(model_glm_2,
                     data = titanic_imputed,
                     y = titanic_imputed$survived,
                     label = "glm2")
eva_glm_2 <- model_evaluation(glm_audit_2)

plotD3_lift(eva_glm, eva_glm_2)

}
\seealso{
\code{\link{plot_lift}}
}
