% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/compute.AShomz.R
\name{compute.AShomz}
\alias{compute.AShomz}
\title{Compute allele specific homozygosity.}
\usage{
compute.AShomz(dat, tolerance = 0.01, sort.var = c("focal", "allele"),
  sort.asc = rep(TRUE, length(sort.var)))
}
\arguments{
\item{dat}{A data.frame with 5 required variables (having the names listed below):
\tabular{ll}{
     \code{haplo.freq} \tab A numeric vector of haplotype frequencies.\cr
      \code{locus1} \tab A character vector indentifying the first locus.\cr
      \code{locus2} \tab A character vector indentifying the second locus.\cr
      \code{allele1} \tab A character vector indentifying the allele at locus 1.\cr
      \code{allele2} \tab A character vector indentifying the allele at locus 1.\cr
      }}

\item{tolerance}{A threshold for the sum of the haplotype frequencies.
If the sum of the haplotype frequencies is greater than 1+tolerance or less
than 1-tolerance an error is returned. The default is 0.01.}

\item{sort.var}{a vector of variable names specifying the "sort by" variables.
The default is c("focal","allele").}

\item{sort.asc}{a vector of TRUE/FALSE values, with the same length as "sort.var",
                     indicating whether sorting of each variable is in ascending order.
                     The default order is ascending.}
}
\value{
The return value is a dataframe with the following components:
 \tabular{ll}{
 \code{loci}	\tab The locus names separated by "-".\cr
 \code{focal}	\tab The name of the focal locus (locus conditioned on).\cr
 \code{allele}	\tab The name of the focal allele (allele conditioned on).\cr
 \code{allele.freq}	\tab The frequency of the focal allele.\cr
 \code{as.homz}	\tab The allele specific homozygosity (on haplotypes with the focal allele).\cr
 }
}
\description{
A function to compute allele specific homozygosity values for haplotype frequency data.
The allele specific homozygosity is the homozygosity statistic computed for alleles at
one locus that are found on haplotypes with a specific allele (the focal allele) at the
other locus (the focal locus).
}
\section{Details}{

A warning message is given if the sum of the haplotype frequencies is greater than 1.01 or less
than 0.99 (regardless of the \code{tolerance} setting). The haplotype frequencies that are
passed to the function are normalized within the function to sum to 1.0 by dividing each
frequency by the sum of the passed frequencies.
}
\examples{
library(asymLD)

# An example using haplotype frequencies from Wilson(2010)
data(hla.freqs)
hla.dr_dq <- hla.freqs[hla.freqs$locus1=="DRB1" & hla.freqs$locus2=="DQB1",]
compute.ALD(hla.dr_dq)
compute.AShomz(hla.dr_dq, sort.var=c("focal","allele"), sort.asc=c(TRUE,TRUE))
compute.AShomz(hla.dr_dq, sort.var=c("focal","allele.freq"), sort.asc=c(FALSE,FALSE))
# Note that there is substantially less variablity (higher ALD) for HLA*DQB1
# conditional on HLA*DRB1 than for HLA*DRB1 conditional on HLA*DQB1, indicating
# that the overall variation for DQB1 is relatively low given specific DRB1 alleles.
# The largest contributors to ALD{DQB1|DRB1} are the DRB1*0301 and DRB1*1501 focal
# alleles, which have high allele frequencies and also have high allele specific
# homozygosity values.
}

