% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinations.R
\name{ncombinations}
\alias{ncombinations}
\title{Number of combinations}
\usage{
ncombinations(x = NULL, k = NULL, n = NULL, v = NULL,
  freq = NULL, replace = FALSE, bigz = FALSE)
}
\arguments{
\item{x}{an integer or a vector, will be treated as \code{n} if integer; otherwise, will be treated as \code{v}.
Should not be specified together with \code{n} and \code{v}.}

\item{k}{an integer, the number of items drawn, defaults to \code{n} if \code{freq} is \code{NULL} else \code{sum(freq)}}

\item{n}{an integer, the total number of items, its value may be implicitly deduced from \code{length(v)} or \code{length(freq)}}

\item{v}{a vector to be drawn, defaults to \code{1:n}.}

\item{freq}{an integer vector of item repeat frequencies}

\item{replace}{an logical to draw items with replacement}

\item{bigz}{an logical to use \link[gmp:bigz]{gmp::bigz}}
}
\description{
Number of combinations
}
\examples{
ncombinations(5, 2)
ncombinations(LETTERS, k = 5)

# integer overflow
\dontrun{ncombinations(40, 15)}
ncombinations(40, 15, bigz = TRUE)

# number of combinations of `c("a", "b", "b")`
# they are `c("a", "b")` and `c("b", "b")`
ncombinations(k = 2, freq = c(1, 2))

# zero sized combinations
ncombinations(5, 0)
ncombinations(5, 6)
ncombinations(0, 1)
ncombinations(0, 0)

}
\seealso{
\link{combinations} for generating all combinations and \link{icombinations} for iterating combinations
}
