% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{apa_flextable}
\alias{apa_flextable}
\title{Convert data to flextable consistent with APA style}
\usage{
apa_flextable(
  data,
  row_title_column = NULL,
  row_title_align = "left",
  row_title_prefix = "",
  row_title_sep = " ",
  row_title_border = list(color = "gray20", style = "solid", width = 1),
  left_column_padding = 20,
  col_keys = colnames(data),
  cwidth = 0.75,
  cheight = 0.25,
  header_align_vertical = c("top", "middle", "bottom"),
  separate_headers = TRUE,
  apa_style = TRUE,
  font_family = NULL,
  font_size = 12,
  text_color = "black",
  border_color = "black",
  border_width = 0.5,
  line_spacing = 2,
  horizontal_padding = 3,
  table_align = "left",
  layout = "autofit",
  table_width = 1,
  markdown = TRUE,
  markdown_header = markdown,
  markdown_body = markdown,
  no_markdown_columns = NULL,
  no_markdown_columns_header = NULL,
  no_format_columns = NULL,
  auto_format_columns = TRUE,
  column_formats = NULL,
  pretty_widths = TRUE,
  add_breaks_between_spanners = TRUE,
  ...
)
}
\arguments{
\item{data}{data.frame or tibble}

\item{row_title_column}{Column name or tidyselect function. column to group rows}

\item{row_title_align}{alignment of row title ("left", "center", "right")}

\item{row_title_prefix}{text to be added to each title}

\item{row_title_sep}{separator for prefix}

\item{row_title_border}{list of flextable styles}

\item{left_column_padding}{Number of points the left column is padded (only relevant when there is a \code{row_title_column} and \code{row_title_align = "left"})}

\item{col_keys}{column keys passed to flextable (defaults data column names)}

\item{cwidth}{initial cell width in inches}

\item{cheight}{initial cell height in inches}

\item{header_align_vertical}{vertical alignment of headers. Can be "top", "middle", or "bottom"}

\item{separate_headers}{separate header rows (default: \code{TRUE})}

\item{apa_style}{apply \code{apa_style} function (default: \code{TRUE})}

\item{font_family}{font family}

\item{font_size}{font size}

\item{text_color}{text color}

\item{border_color}{border color}

\item{border_width}{border width in pixels}

\item{line_spacing}{spacing between lines}

\item{horizontal_padding}{horizontal padding (in pixels)}

\item{table_align}{table alignment ("left", "center", "right")}

\item{layout}{table layout ("autofit", "fixed")}

\item{table_width}{table width (in pixels, 0 for auto)}

\item{markdown}{apply markdown formatting to header and body}

\item{markdown_header}{apply markdown formatting to header}

\item{markdown_body}{apply markdown formatting to body}

\item{no_markdown_columns}{body columns that should not be treated as markdown}

\item{no_markdown_columns_header}{column headers that should not be treated as markdown}

\item{no_format_columns}{Column name or tidyselect function. selected columns are not formatted}

\item{auto_format_columns}{if true, will attempt to format some columns automatically}

\item{column_formats}{a column_formats object}

\item{pretty_widths}{apply \code{pretty_widths} function}

\item{add_breaks_between_spanners}{add breaks between spanners if TRUE}

\item{...}{arguments passed to \code{apa_style}}
}
\value{
flextable::flextable
}
\description{
The \code{apa_flextable} function performs a number of formatting operations on the data before and after the data are sent to flextable. See Details.
}
\details{
Roughly speaking, \code{apa_flextable} performs these operations by default:
\enumerate{
\item Apply as_grouped_data and restructure row titles, if \code{row_title} is specified.
\item Format data with apa_format_columns if \code{auto_format_columns = TRUE}
\item Separate headers into multiple header rows if \code{separate_headers = TRUE}
\item Apply \code{flextable::flextable}
\item Apply \code{flextable::surround} to make borders to separate row groups, if any.
\item Apply the \code{apa_style} function (table formatting and markdown conversion) if \code{apa_style = TRUE}
\item Apply \code{pretty_widths} if \code{pretty_widths = TRUE}
}
}
\examples{
library(dplyr)
library(tidyr)
library(flextable)
mtcars \%>\%
  dplyr::select(vs, am, gear, carb) |>
  tidyr::pivot_longer(-vs,  names_to = "Variable") |>
  dplyr::summarise(Mean = round(mean(value), 2),
                   SD = round(sd(value), 2),
                   .by = c(Variable,vs)) |>
  dplyr::mutate(vs = factor(vs, levels = 0:1, labels = c("Automatic", "Manual"))) |>
  apa_flextable(row_title_column= vs,  row_title_align = "center") |>
  align(j = 2:3, align = "center")
}
